/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.HTTPClient;

import homemonitor.HTTPClient.HTTPClientResult;
import homemonitor.HTTPClient.RandomGenerator;
import homemonitor.TCPProxy.TCPProxyInterface;
import homemonitor.TCPProxy.TCPProxyResponseInterface;
import homemonitor.Utility;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class HTTPClient
implements TCPProxyResponseInterface {
    private static Logger log = Logger.getLogger(HTTPClient.class);
    private TCPProxyInterface tcpProxy;
    private long sessionId;
    private String requestLine;
    private HashMap<String, String> requestHeaders = new HashMap();
    private HashMap<String, String> responseHeaders = new HashMap();
    private int statusCode;
    private ByteArrayOutputStream contentBuffer = new ByteArrayOutputStream();
    private StringBuilder headerBuffer = new StringBuilder();
    private boolean sentAuthentication = false;
    private boolean gotHeaders = false;
    private String sep = "\r\n";
    private String sepOnlyN = "\n";
    private String username = "";
    private String password = "";
    private HTTPClientResult resultCallback;
    private int responseContentLength = -1;
    private boolean onRequestCompleteCalled = false;
    private int nonceCount = 0;
    private URL url = null;
    private RandomGenerator randomGenerator;
    private String deviceId;
    private String authType = null;
    private String authParams;
    private SendMethod sendMethod;
    private Map<String, String> additionalRequestHeaders;
    private byte[] postBody;

    public HTTPClient(TCPProxyInterface tcpProxy, HTTPClientResult result) {
        this.tcpProxy = tcpProxy;
        this.resultCallback = result;
    }

    public boolean get(String deviceId, URL url) {
        log.debug((Object)("get(deviceId=" + deviceId + ", url=" + url.toString() + ")"));
        this.url = url;
        this.deviceId = deviceId;
        this.sendMethod = SendMethod.GET;
        if (url.getUserInfo() != null) {
            String[] userInfo = url.getUserInfo().split(":");
            if (userInfo.length > 0) {
                this.username = userInfo[0];
            }
            if (userInfo.length > 1) {
                this.password = userInfo[1];
            }
        }
        this.requestLine = "GET " + url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : "") + " HTTP/1.1";
        this.requestHeaders.put("Host", url.getHost());
        this.requestHeaders.put("Connection", "close");
        if (this.authType == null && !this.username.equals("")) {
            this.addBasicAuth();
        }
        log.trace((Object)("authType: " + this.authType));
        log.trace((Object)("authParams: " + this.authParams));
        log.trace((Object)("nonceCount: " + this.nonceCount));
        if (this.tcpProxy == null) {
            log.error((Object)"HTTPClient.get(): tcpProxy == null");
            return false;
        }
        this.sessionId = this.tcpProxy.connect(deviceId, url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), this);
        log.debug((Object)("HTTPClient: sessionId: " + this.sessionId + ", sending: " + this.requestLine));
        if (this.sessionId == 0L) {
            log.debug((Object)"SessionId is 0. Returning false value!");
            return false;
        }
        return true;
    }

    public boolean post(String deviceId, URL url, Map<String, String> additionalRequestHeaders, byte[] body) {
        log.debug((Object)("post(deviceId=" + deviceId + ", url=" + url.toString() + ", additionalRequestHeaders=" + additionalRequestHeaders + ", body=" + body + ")"));
        this.url = url;
        this.deviceId = deviceId;
        this.sendMethod = SendMethod.POST;
        this.additionalRequestHeaders = additionalRequestHeaders;
        this.postBody = body;
        if (url.getUserInfo() != null) {
            String[] userInfo = url.getUserInfo().split(":");
            if (userInfo.length > 0) {
                this.username = userInfo[0];
            }
            if (userInfo.length > 1) {
                this.password = userInfo[1];
            }
        }
        this.requestLine = "POST " + url.getPath() + " HTTP/1.1";
        this.requestHeaders.put("Host", url.getHost());
        this.requestHeaders.put("Connection", "close");
        this.requestHeaders.put("Content-Length", String.valueOf(body.length));
        if (additionalRequestHeaders != null) {
            this.requestHeaders.putAll(additionalRequestHeaders);
        }
        if (this.authType == null && !this.username.equals("")) {
            this.addBasicAuth();
        }
        log.trace((Object)("authType: " + this.authType));
        log.trace((Object)("authParams: " + this.authParams));
        log.trace((Object)("nonceCount: " + this.nonceCount));
        if (this.tcpProxy == null) {
            log.error((Object)"HTTPClient.post(): tcpProxy == null");
            return false;
        }
        this.sessionId = this.tcpProxy.connect(deviceId, url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), this);
        log.debug((Object)("HTTPClient: sessionId: " + this.sessionId + ", sending: " + this.requestLine));
        if (this.sessionId == 0L) {
            log.debug((Object)"SessionId is 0. Returning false value!");
            return false;
        }
        return true;
    }

    private void addBasicAuth() {
        log.trace((Object)"start addBasicAuth");
        String token = new String(Base64.encodeBase64((byte[])(String.valueOf(this.username) + ":" + this.password).getBytes()));
        this.requestHeaders.put("Authorization", "Basic " + token);
    }

    private String formatNonceCount(int nonceCount) {
        DecimalFormat nft = new DecimalFormat("#0000.###");
        nft.setMinimumIntegerDigits(8);
        nft.setDecimalSeparatorAlwaysShown(false);
        return nft.format(nonceCount);
    }

    private void addDigestAuth(String paramsText) {
        log.trace((Object)("start addDigestAuth(" + paramsText + ")"));
        Map<String, String> params = this.parseAuthenticateParams(paramsText);
        String entityBody = "";
        String cnonce = this.randomGenerator.generate();
        ++this.nonceCount;
        String nc = this.formatNonceCount(this.nonceCount);
        String uri = String.valueOf(this.url.getPath()) + (this.url.getQuery() != null ? "?" + this.url.getQuery() : "");
        String token = this.generateDigestAuthHTTPToken(this.username, this.password, params.get("realm"), params.get("nonce"), cnonce, nc, uri, params.get("qop"), entityBody);
        StringBuilder response = new StringBuilder();
        response.append("Digest username=\"").append(this.username).append("\",");
        response.append("realm=\"").append(params.get("realm")).append("\",");
        response.append("nonce=\"").append(params.get("nonce")).append("\",");
        response.append("uri=\"").append(uri).append("\",");
        response.append("qop=").append(params.get("qop")).append(",");
        response.append("nc=").append(nc).append(",");
        response.append("cnonce=\"").append(cnonce).append("\",");
        response.append("response=\"").append(token).append("\"");
        if (params.containsKey("opaque")) {
            response.append(",opaque=\"").append(params.get("opaque")).append("\"");
        }
        log.trace((Object)("Created digest token: " + response.toString()));
        this.requestHeaders.put("Authorization", response.toString());
    }

    private Map<String, String> parseAuthenticateParams(String paramsText) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] params = paramsText.split(",");
        int i = 0;
        while (i < params.length) {
            String[] paramValue = params[i].split("=");
            if (paramValue.length == 2) {
                String key = paramValue[0].trim().toLowerCase();
                String value = paramValue[1].replace("\"", "").trim();
                result.put(key, value);
            }
            ++i;
        }
        return result;
    }

    private String generateDigestAuthHTTPToken(String username, String password, String realm, String nonce, String cnonce, String nc, String uri, String qop, String entityBody) {
        String ha1 = Utility.generateMD5(String.valueOf(username) + ":" + realm + ":" + password);
        String ha2Data = "GET:" + uri;
        if (qop != null && qop.equals("auth-int")) {
            ha2Data = String.valueOf(ha2Data) + Utility.generateMD5(entityBody);
        }
        String ha2 = Utility.generateMD5(ha2Data);
        String response = null;
        response = qop == null || qop.length() == 0 ? Utility.generateMD5(String.valueOf(ha1) + ":" + nonce + ":" + ha2) : Utility.generateMD5(String.valueOf(ha1) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2);
        return response;
    }

    private void sendRequest() {
        log.trace((Object)"start sendRequest");
        StringBuilder request = new StringBuilder(this.requestLine);
        request.append(this.sep);
        for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            request.append(String.valueOf(key) + ": " + value + this.sep);
        }
        request.append(this.sep);
        log.debug((Object)("sendRequest: " + request.toString()));
        if (this.sendMethod == SendMethod.GET) {
            this.tcpProxy.send(this.sessionId, request.toString().getBytes());
        } else {
            ByteArrayOutputStream postBodyStream = new ByteArrayOutputStream();
            byte[] req = request.toString().getBytes();
            postBodyStream.write(req, 0, req.length);
            postBodyStream.write(this.postBody, 0, this.postBody.length);
            log.trace((Object)("request length: " + postBodyStream.size()));
            this.tcpProxy.send(this.sessionId, postBodyStream.toByteArray());
        }
        this.gotHeaders = false;
        this.headerBuffer = new StringBuilder();
    }

    private void extractResponseHeaders(String headersBuffer) {
        String[] headerLines = headersBuffer.split(this.sep);
        this.responseHeaders.clear();
        int i = 0;
        while (i < headerLines.length) {
            String[] headerLine = headerLines[i].split(":\\s*");
            if (headerLine.length == 2) {
                this.responseHeaders.put(headerLine[0].toLowerCase(), headerLine[1]);
            }
            ++i;
        }
    }

    private boolean handle() {
        if (this.statusCode == 401 && this.responseHeaders.get("www-authenticate") != null) {
            log.trace((Object)"Authorization required");
            if (this.sentAuthentication) {
                if (this.resultCallback != null) {
                    this.resultCallback.onNoAccessError();
                }
                log.trace((Object)"disconnect");
                this.tcpProxy.disconnect(this.sessionId);
                return false;
            }
            String auth = this.responseHeaders.get("www-authenticate");
            int spacePos = auth.indexOf(32);
            this.authType = auth.substring(0, spacePos).toLowerCase();
            this.authParams = auth.substring(spacePos + 1);
            if (this.authType.equals("basic")) {
                log.trace((Object)"Authorization type: basic");
                this.addBasicAuth();
            } else {
                log.trace((Object)"Authorization type: digest");
                this.addDigestAuth(this.authParams);
            }
            log.trace((Object)"Sending auth request");
            this.tcpProxy.disconnect(this.sessionId);
            this.contentBuffer.reset();
            if (this.sendMethod == SendMethod.GET) {
                this.get(this.deviceId, this.url);
            } else {
                this.post(this.deviceId, this.url, this.additionalRequestHeaders, this.postBody);
            }
            this.sentAuthentication = true;
            return false;
        }
        return true;
    }

    @Override
    public void received(long sessionId, byte[] data) {
        log.trace((Object)("start received " + data.length + " bytes for sessionId=" + sessionId + ")"));
        if (this.sessionId != sessionId) {
            return;
        }
        if (this.gotHeaders) {
            this.contentBuffer.write(data, 0, data.length);
        } else {
            int prevHeaderBufferSize = this.headerBuffer.length();
            this.headerBuffer.append(new String(data));
            int headersEnd = this.headerBuffer.indexOf(String.valueOf(this.sep) + this.sep);
            if (headersEnd < 0) {
                headersEnd = this.headerBuffer.indexOf(String.valueOf(this.sepOnlyN) + this.sepOnlyN);
            }
            int headersEndData = headersEnd - prevHeaderBufferSize;
            if (headersEnd > 0) {
                int startOfHeaders;
                log.trace((Object)("headerBuffer: " + this.headerBuffer.toString()));
                int responseLineEnd = this.headerBuffer.toString().indexOf(this.sep);
                String responseLine = this.headerBuffer.substring(0, responseLineEnd);
                String[] responseLineParts = responseLine.split(" ");
                if (responseLineParts.length < 2) {
                    if (this.resultCallback != null) {
                        this.resultCallback.onError(this.contentBuffer.toByteArray());
                    }
                    this.tcpProxy.disconnect(sessionId);
                    return;
                }
                String statusCodeStr = responseLineParts[1];
                this.statusCode = Integer.parseInt(statusCodeStr);
                int endOfHeaders = this.headerBuffer.indexOf(String.valueOf(this.sep) + this.sep);
                int sepLength = this.sep.length();
                if (endOfHeaders < 0) {
                    endOfHeaders = this.headerBuffer.indexOf(String.valueOf(this.sepOnlyN) + this.sepOnlyN);
                    sepLength = this.sepOnlyN.length();
                }
                if ((startOfHeaders = responseLineEnd + sepLength) < endOfHeaders) {
                    String headersBuffer = this.headerBuffer.substring(startOfHeaders, endOfHeaders);
                    log.trace((Object)("got headers: " + headersBuffer));
                    this.extractResponseHeaders(headersBuffer);
                    if (this.responseHeaders.containsKey("content-length")) {
                        this.responseContentLength = Integer.parseInt(this.responseHeaders.get("content-length"));
                    }
                }
                this.gotHeaders = true;
                log.trace((Object)("end of headers: " + (headersEndData + sepLength * 2)));
                if (headersEndData + sepLength * 2 < data.length) {
                    this.contentBuffer.write(data, headersEndData + sepLength * 2, data.length - headersEndData - sepLength * 2);
                }
                if (this.statusCode == 401) {
                    if (this.contentBuffer.size() < this.responseContentLength) {
                        return;
                    }
                    if (!this.handle()) {
                        return;
                    }
                }
                if (this.statusCode < 200 || this.statusCode >= 300) {
                    if (this.resultCallback != null) {
                        this.resultCallback.onHttpError(this.statusCode, this.contentBuffer.toByteArray());
                    }
                    this.tcpProxy.disconnect(sessionId);
                    return;
                }
                if (this.resultCallback != null) {
                    this.resultCallback.onGotHeaders(this.responseHeaders);
                }
            }
        }
        if (this.responseContentLength != -1 && this.contentBuffer.size() >= this.responseContentLength) {
            if (!this.sentAuthentication && !this.handle()) {
                return;
            }
            if (!this.onRequestCompleteCalled && this.resultCallback != null) {
                log.debug((Object)"calling onRequestComplete (contentLength)");
                this.resultCallback.onRequestComplete(this.statusCode, this.contentBuffer.toByteArray());
                this.onRequestCompleteCalled = true;
            }
            this.tcpProxy.disconnect(sessionId);
        }
    }

    @Override
    public void accepted(long sessionId) {
        log.debug((Object)("start accepted(" + sessionId + ")"));
        if (this.sessionId != sessionId) {
            return;
        }
        this.sendRequest();
    }

    @Override
    public void error(long sessionId) {
        log.debug((Object)("start error(" + sessionId + ")"));
        if (this.sessionId != sessionId) {
            return;
        }
        if (this.resultCallback != null) {
            this.resultCallback.onError(this.contentBuffer.toByteArray());
        }
    }

    @Override
    public void closed(long sessionId) {
        log.debug((Object)("start closed(" + sessionId + ")"));
        if (this.sessionId != sessionId) {
            return;
        }
        if (this.gotHeaders) {
            if (!this.onRequestCompleteCalled && this.resultCallback != null) {
                log.debug((Object)"calling onRequestComplete (closed)");
                this.resultCallback.onRequestComplete(this.statusCode, this.contentBuffer.toByteArray());
                this.onRequestCompleteCalled = true;
            }
            this.sessionId = 0L;
        } else if (this.resultCallback != null) {
            this.resultCallback.onError(this.contentBuffer.toByteArray());
        }
    }

    @Override
    public void deviceDisconnected(long sessionId) {
        log.debug((Object)("start deviceDisconnected(" + sessionId + ")"));
        if (this.sessionId != sessionId) {
            return;
        }
        if (this.resultCallback != null) {
            this.resultCallback.onError(this.contentBuffer.toByteArray());
        }
    }

    public void setRandomGenerator(RandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void cancel() {
        this.tcpProxy.disconnect(this.sessionId);
    }

    private static enum SendMethod {
        GET,
        POST;

    }
}

