/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.GDUpdate;

import homemonitor.GDUpdate.UpdateServerCmdInterface;
import homemonitor.Utility;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class UpdateServerCmdImpl
implements UpdateServerCmdInterface {
    private static Logger log = Logger.getLogger(UpdateServerCmdImpl.class);
    private String firmwareFile;
    private String tftpIpAddress;
    private int tftpPort;

    public void setFirmwareFile(String firmwareFile) {
        this.firmwareFile = firmwareFile;
    }

    public void setTftpIpAddress(String tftpIpAddress) {
        this.tftpIpAddress = tftpIpAddress;
    }

    public void setTftpPort(int tftpPort) {
        this.tftpPort = tftpPort;
    }

    @Override
    public ByteBuffer process(String publicIp, ByteBuffer buffer) {
        log.debug((Object)("UpdateServerCmdImpl.process: publicIP: " + publicIp + ", data: " + buffer.toString()));
        if (buffer.position() < 10) {
            log.error((Object)("UpdateServerCmdImpl.process failed, data too short (" + buffer.position() + ")"));
            return null;
        }
        byte[] request = buffer.array();
        String mac = Utility.byteArrayToHexString(request, 0, 6, ":");
        int version = Utility.byteArrayToInt(request, 6, 2);
        byte correct = request[8];
        byte platformId = request[9];
        log.debug((Object)("IP: " + publicIp + ", MAC: " + mac + ", Version: " + version + ", PlatformID: " + platformId + ", Correct: " + correct));
        byte[] response = new byte[134];
        Arrays.fill(response, (byte)0);
        int i = 0;
        while (i < this.firmwareFile.length()) {
            response[i] = (byte)this.firmwareFile.charAt(i);
            ++i;
        }
        String[] addrSArray = this.tftpIpAddress.split("\\.");
        int i2 = 0;
        while (i2 < 4) {
            response[128 + i2] = (byte)Integer.parseInt(addrSArray[i2]);
            ++i2;
        }
        byte[] portArray = Utility.intToByteArray(this.tftpPort);
        System.arraycopy(portArray, 2, response, 132, 2);
        return ByteBuffer.wrap(response);
    }
}

