/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.google.gson.Gson;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.ExceptionsTrigger;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import org.apache.http.entity.StringEntity;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UpnpPortForwardingServiceImpl.class, Utils.class, SetUpUpnpForwardingResult.class, Gson.class, StringEntity.class, ExceptionsTrigger.class, SetUpForwardingException.class, System.class})
public class UpnpPortForwardingServiceImplTests {
    private UpnpPortForwardingServiceImpl upnpService;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private Integer staticExternalPort = 443;
    private AppServerConnector appServerConnector;
    private short portPoolBegin = (short)15800;
    private short portPoolEnd = (short)15899;
    private String portPoolOrder = "asc";
    private ThreadPoolTaskExecutor taskExecutor;

    @Before
    public void setUp() {
        this.upnpService = new UpnpPortForwardingServiceImpl();
        this.gatewayDeviceConnection = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.upnpService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.upnpApp = (UPnPApp)PowerMock.createMock(UPnPApp.class);
        this.upnpService.setUpnpApp(this.upnpApp);
        this.appServerConnector = (AppServerConnector)PowerMock.createMock(AppServerConnector.class);
        this.upnpService.setAppServerConnector(this.appServerConnector);
        this.upnpService.setStaticExternalPort(this.staticExternalPort);
        this.upnpService.setPortPoolBegin(this.portPoolBegin);
        this.upnpService.setPortPoolEnd(this.portPoolEnd);
        this.upnpService.setPoolCheckOrder(this.portPoolOrder);
        this.taskExecutor = (ThreadPoolTaskExecutor)PowerMock.createMock(ThreadPoolTaskExecutor.class);
        this.upnpService.setTaskExecutor(this.taskExecutor);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(System.class);
    }

    @Test
    public void testSetUpForwardingWithPort0Checking() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 0;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn((Object)true);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithPort0CommunicationProblem() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 0;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn((Object)false);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNon0PortChecking() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 15801;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        device.setUpnpPort(upnpPort.shortValue());
        device.setUpnpOldPort(true);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, upnpPort.shortValue())).andReturn((Object)true);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNon0PortCommunicationProblem() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 15801;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        device.setUpnpPort(upnpPort.shortValue());
        device.setUpnpOldPort(true);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, upnpPort.shortValue())).andReturn((Object)false);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNullPort() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn((Object)true);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithHasNotUpmpIgd() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)false);
        device.setUpnpPort(this.staticExternalPort.shortValue());
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(this.staticExternalPort);
        result.setState(UpnpForwardingState.Works);
        result.setStatusCode(0);
        result.setReason("Success");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)((Object)errorCode));
        Assert.assertEquals((Object)result, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingDeviceNotConnected() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        try {
            this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)((Object)SetUpUpnpForwardingResponse.ErrorCode.DEVICE_NOT_CONNECTED), (Object)((Object)errorCode));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingNoDeviceId() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "";
        Integer upnpPort = null;
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        try {
            this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)((Object)SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID), (Object)((Object)errorCode));
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusWorks() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = true;
        short port = 15801;
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        device.setLocalIpAddress(localIp);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)port);
        device.setUpnpPort(port);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(new Integer(port));
        result.setState(UpnpForwardingState.Works);
        result.setStatusCode(0);
        result.setReason("Success");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCodeLowerThan0() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = -1;
        boolean works = false;
        int port = 0;
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(new Integer(port));
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.ASC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15801);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15801)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.DESC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolEnd);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15898);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15898)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode718Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 718;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.ASC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15801);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15801)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode718Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 718;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.DESC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolEnd);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15898);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15898)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode402Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 402;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.ASC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15801);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15801)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode402Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 402;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.DESC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolEnd);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)15898);
        EasyMock.expect((Object)this.upnpApp.setupForwarding(mac, (short)15898)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0AndEndOfPoolAscending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.ASC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolEnd);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(new Integer(0));
        result.setState(UpnpForwardingState.EndOfPool);
        result.setStatusCode(0);
        result.setReason("All ports busy");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        device.setUpnpPort(this.portPoolBegin);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0AndEndOfPoolDescending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, (String)"poolCheckOrder", (Object)((Object)UpnpPortForwardingServiceImpl.Order.DESC));
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        Long now = new Long(1234L);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.isUpnpOldPort()).andReturn((Object)false);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)this.portPoolBegin);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, (Object[])new Object[0]).andReturn((Object)result);
        result.setUpnpPort(new Integer(0));
        result.setState(UpnpForwardingState.EndOfPool);
        result.setStatusCode(0);
        result.setReason("All ports busy");
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        device.setUpnpPort(this.portPoolEnd);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateStatusOnAppServer() throws Exception {
        String mac = "testMac";
        SetUpUpnpForwardingResult status = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        Gson gson = (Gson)PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, (Object[])new Object[0]).andReturn((Object)gson);
        String jsonResult = "testJsonResult";
        EasyMock.expect((Object)gson.toJson((Object)status)).andReturn((Object)jsonResult);
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.UPNP_STATUS, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.VALUE, jsonResult);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.upnpService.updateStatusOnAppServer(mac, status);
        PowerMock.verifyAll();
    }
}

