/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.google.gson.Gson;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.UpnpPortForwardingService;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UpnpPortForwardingServiceImpl
implements UpnpPortForwardingService,
UPnPApp.Callback {
    private static Logger log = Logger.getLogger(UpnpPortForwardingServiceImpl.class);
    private boolean upnpEnabled;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private Integer staticExternalPort;
    private AppServerConnector appServerConnector;
    private short portPoolBegin;
    private short portPoolEnd;
    private Order poolCheckOrder;
    private ThreadPoolTaskExecutor taskExecutor;

    @Autowired
    @Required
    public void setTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Autowired
    @Required
    public void setUpnpApp(UPnPApp upnpApp) {
        this.upnpApp = upnpApp;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnection gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Value(value="${gatewayClientService.upnpEnabled:true}")
    public void setUpnpEnabled(boolean upnpEnabled) {
        this.upnpEnabled = upnpEnabled;
    }

    @Value(value="${UpnpPortForwarding.staticExternalPort}")
    public void setStaticExternalPort(Integer staticExternalPort) {
        this.staticExternalPort = staticExternalPort;
    }

    @Value(value="${UpnpPortForwarding.portPoolBegin:15800}")
    public void setPortPoolBegin(short portPoolBegin) {
        this.portPoolBegin = portPoolBegin;
    }

    @Value(value="${UpnpPortForwarding.portPoolEnd:15899}")
    public void setPortPoolEnd(short portPoolEnd) {
        this.portPoolEnd = portPoolEnd;
    }

    @Value(value="${UpnpPortForwarding.portPoolCheckOrder:asc}")
    public void setPoolCheckOrder(String poolCheckOrder) {
        this.poolCheckOrder = Order.parse(poolCheckOrder);
    }

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @PostConstruct
    public void initialize() {
        this.upnpApp.registerCallback(this);
    }

    @Override
    public SetUpUpnpForwardingResult setUpForwarding(String mac, Integer upnpPort) {
        if (Utils.isBlank(mac)) {
            throw new SetUpForwardingException(SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (!this.upnpEnabled) {
            log.trace((Object)("start setUpForwarding(mac=" + mac + ") - UPNP is disabled"));
            throw new SetUpForwardingException(SetUpUpnpForwardingResponse.ErrorCode.FORWARDING_DISABLED);
        }
        log.debug((Object)("start setUpForwarding(mac=" + mac + ")"));
        GatewayDevice device = this.gatewayDeviceConnection.findById(mac);
        if (device == null) {
            throw new SetUpForwardingException(SetUpUpnpForwardingResponse.ErrorCode.DEVICE_NOT_CONNECTED);
        }
        if (device.hasUpnpIgd()) {
            short port;
            short s = port = upnpPort != null ? (short)upnpPort.intValue() : (short)0;
            if (port != 0) {
                log.debug((Object)"UPnP: checking if we can set up forwarding on old port...");
                device.setUpnpPort(port);
                device.setUpnpOldPort(true);
                if (!this.upnpApp.setupForwarding(mac, port)) {
                    log.debug((Object)"Failed to set up port forwarding cause commnication problem");
                    return this.forwardingStatusSave(device, (short)0, UpnpForwardingState.CommunicationProblem, 0);
                }
                return this.forwardingStatusSave(device, port, UpnpForwardingState.Checking, 0);
            }
            log.debug((Object)"UPnP: setting new forwarding...");
            device.setUpnpPort(this.poolCheckOrder == Order.ASC ? this.portPoolBegin : this.portPoolEnd);
            device.setUpnpOldPort(false);
            if (!this.upnpApp.setupForwarding(mac, device.getUpnpPort())) {
                return this.forwardingStatusSave(device, (short)0, UpnpForwardingState.CommunicationProblem, 0);
            }
            return this.forwardingStatusSave(device, (short)0, UpnpForwardingState.Checking, 0);
        }
        return this.forwardingStatusSave(device, this.staticExternalPort.shortValue(), UpnpForwardingState.Works, 0);
    }

    private SetUpUpnpForwardingResult forwardingStatusSave(GatewayDevice device, short port, UpnpForwardingState reason, int statusCode) {
        short upnp_port = 0;
        String reason_str = null;
        if (reason == UpnpForwardingState.Works) {
            upnp_port = port;
        }
        switch (reason) {
            case Works: {
                reason_str = "Success";
                break;
            }
            case Checking: {
                reason_str = "Checking...";
                break;
            }
            case CommunicationProblem: {
                reason_str = "Communication Problem";
                break;
            }
            case EndOfPool: {
                reason_str = "All ports busy";
                break;
            }
            case UnhandledErrorCode: {
                reason_str = "Unhandled Error Code: " + statusCode;
                break;
            }
            default: {
                reason_str = "unknown problem";
            }
        }
        log.debug((Object)("UPnP: forwardingStatusSave: " + reason.name()));
        if (reason != UpnpForwardingState.Checking) {
            device.setUpnpPort(upnp_port);
        }
        SetUpUpnpForwardingResult result = new SetUpUpnpForwardingResult();
        result.setUpnpPort(Integer.valueOf(upnp_port));
        result.setState(reason);
        result.setStatusCode(statusCode);
        result.setReason(reason_str);
        result.setPublicIp(device.getPublicIpAddress());
        if (reason != UpnpForwardingState.Checking) {
            this.notifyAppServer(device.getMac(), result);
        }
        return result;
    }

    private void notifyAppServer(final String mac, final SetUpUpnpForwardingResult status) {
        log.trace((Object)("start notifyAppServer(mac=" + mac + ", status=" + status + ")"));
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpnpPortForwardingServiceImpl.this.updateStatusOnAppServer(mac, status);
            }
        });
    }

    void updateStatusOnAppServer(String mac, SetUpUpnpForwardingResult status) {
        log.trace((Object)("start updateStatusOnAppServer(mac=" + mac + ", status=" + status + ")"));
        Gson gson = new Gson();
        String json = gson.toJson((Object)status);
        Message msg = new Message(Message.Type.UPNP_STATUS, mac);
        msg.setParam(Message.Param.VALUE, json);
        this.appServerConnector.addMessage(msg);
    }

    @Override
    public void forwardingStatus(String id, String localIp, int statusCode, boolean works) {
        log.debug((Object)("start forwardingStatus(mac=" + id + ", localIp=" + localIp + ", statusCode=" + statusCode + ", works=" + works + ")"));
        GatewayDevice device = this.gatewayDeviceConnection.findById(id);
        device.setUpnpLastCheck(System.currentTimeMillis());
        if (works) {
            log.debug((Object)"forwardingStatus: works");
            device.setLocalIpAddress(localIp);
            this.forwardingStatusSave(device, device.getUpnpPort(), UpnpForwardingState.Works, 0);
        } else {
            log.debug((Object)"forwardingStatus: does not work");
            if (statusCode < 0) {
                log.debug((Object)"forwardingStatus: getStatusCode() < 0");
                this.forwardingStatusSave(device, (short)0, UpnpForwardingState.CommunicationProblem, 0);
            } else if (statusCode == 0) {
                log.debug((Object)"forwardingStatus: getStatusCode() == 0");
                this.startUPnPCheckOnPool(device);
            } else if (statusCode == 718 || statusCode == 402) {
                log.debug((Object)("forwardingStatus: code = " + statusCode));
                this.startUPnPCheckOnPool(device);
            } else {
                log.debug((Object)"forwardingStatus: router problem");
                this.forwardingStatusSave(device, (short)0, UpnpForwardingState.UnhandledErrorCode, statusCode);
            }
        }
    }

    private void startUPnPCheckOnPool(GatewayDevice device) {
        if (device.isUpnpOldPort()) {
            log.debug((Object)"UPnP: starting checking on whole pool of ports...");
            device.setUpnpPort(this.poolCheckOrder == Order.ASC ? this.portPoolBegin : this.portPoolEnd);
            device.setUpnpOldPort(false);
        }
        if (this.poolCheckOrder == Order.ASC) {
            if (device.getUpnpPort() < this.portPoolEnd) {
                log.debug((Object)("forwardingStatus: upnp_port = " + device.getUpnpPort()));
                device.setUpnpPort((short)(device.getUpnpPort() + 1));
                if (!this.upnpApp.setupForwarding(device.getMac(), device.getUpnpPort())) {
                    log.debug((Object)"forwardingStatus: communication problem");
                    this.forwardingStatusSave(device, (short)0, UpnpForwardingState.CommunicationProblem, 0);
                }
            } else {
                log.debug((Object)"forwardingStatus: end of pool");
                this.forwardingStatusSave(device, (short)0, UpnpForwardingState.EndOfPool, 0);
                device.setUpnpPort(this.portPoolBegin);
            }
        } else if (device.getUpnpPort() > this.portPoolBegin) {
            log.debug((Object)("forwardingStatus: upnp_port = " + device.getUpnpPort()));
            device.setUpnpPort((short)(device.getUpnpPort() - 1));
            if (!this.upnpApp.setupForwarding(device.getMac(), device.getUpnpPort())) {
                log.debug((Object)"forwardingStatus: communication problem");
                this.forwardingStatusSave(device, (short)0, UpnpForwardingState.CommunicationProblem, 0);
            }
        } else {
            log.debug((Object)"forwardingStatus: end of pool");
            this.forwardingStatusSave(device, (short)0, UpnpForwardingState.EndOfPool, 0);
            device.setUpnpPort(this.portPoolEnd);
        }
    }

    static enum Order {
        ASC,
        DESC;


        public static Order parse(String text) {
            if (Utils.isBlank(text)) {
                return null;
            }
            try {
                return Order.valueOf(text.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }
}

