/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.SystemSupport;
import com.vestiacom.gdserver.service.impl.UpdateUpnpForwardingServiceImpl;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UpdateUpnpForwardingServiceImpl.class, Utils.class})
public class UpdateUpnpForwardingServiceImplTests {
    private UpdateUpnpForwardingServiceImpl service;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private SystemSupport systemSupport;
    private DaoFactory daoFactory;
    private ServiceFactory serviceFactory;
    private SessionDao sessionDao;

    @Before
    public void setUp() {
        this.service = new UpdateUpnpForwardingServiceImpl();
        this.gatewayDeviceConnection = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.service.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.upnpApp = (UPnPApp)PowerMock.createMock(UPnPApp.class);
        this.service.setUpnpApp(this.upnpApp);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.service.setSystemSupport(this.systemSupport);
        this.daoFactory = (DaoFactory)PowerMock.createMock(DaoFactory.class);
        this.service.setDaoFactory(this.daoFactory);
        this.serviceFactory = (ServiceFactory)PowerMock.createMock(ServiceFactory.class);
        this.service.setServiceFactory(this.serviceFactory);
    }

    @Test
    public void testUpdateForwardingStateForUpnpPort0() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        String mac = "testMac";
        short upnpPort = 0;
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.sessionDao.isDeviceRegisterd(mac)).andReturn((Object)true);
        EasyMock.expect((Object)device.getUpnpLastCheck()).andReturn((Object)0L);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        UpnpPortForwardingServiceImpl upnpForwardingService = (UpnpPortForwardingServiceImpl)PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect((Object)this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn((Object)upnpForwardingService);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpForwardingService.setUpForwarding(mac, 0)).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateForCurrentUpnpNotWorking() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        String mac = "testMac";
        short upnpPort = 1;
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.sessionDao.isDeviceRegisterd(mac)).andReturn((Object)true);
        EasyMock.expect((Object)device.getUpnpLastCheck()).andReturn((Object)0L);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)this.upnpApp.forwardingWorks(mac, upnpPort)).andReturn((Object)false);
        device.setUpnpLastCheck(now);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        UpnpPortForwardingServiceImpl upnpForwardingService = (UpnpPortForwardingServiceImpl)PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect((Object)this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn((Object)upnpForwardingService);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpForwardingService.setUpForwarding(mac, 1)).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateForCurrentUpnpWorking() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        String mac = "testMac";
        short upnpPort = 1;
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.sessionDao.isDeviceRegisterd(mac)).andReturn((Object)true);
        EasyMock.expect((Object)device.getUpnpLastCheck()).andReturn((Object)0L);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)this.upnpApp.forwardingWorks(mac, upnpPort)).andReturn((Object)true);
        device.setUpnpLastCheck(now);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateUpnpCheckRecently() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10000L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.sessionDao.isDeviceRegisterd(mac)).andReturn((Object)true);
        EasyMock.expect((Object)device.getUpnpLastCheck()).andReturn((Object)0L);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDeviceNotRegistered() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)true);
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.sessionDao.isDeviceRegisterd(mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDeviceHasNotUpnpIgd() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect((Object)device.hasUpnpIgd()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateNullFoundDevices() {
        Integer recheckSecs = 10;
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDisabledUpnp() {
        this.service.setUpnpEnabled(false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }
}

