/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.SystemSupport;
import com.vestiacom.gdserver.service.UpdateUpnpForwardingService;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class UpdateUpnpForwardingServiceImpl
implements UpdateUpnpForwardingService {
    private static Logger log = Logger.getLogger(UpdateUpnpForwardingServiceImpl.class);
    private boolean upnpEnabled;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private SystemSupport systemSupport;
    private Integer recheckSecs;
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private ServiceFactory serviceFactory;
    private boolean skipVerification;

    @Autowired
    @Required
    public void setUpnpApp(UPnPApp upnpApp) {
        this.upnpApp = upnpApp;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnection gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Value(value="${gatewayClientService.upnpEnabled:true}")
    public void setUpnpEnabled(boolean upnpEnabled) {
        this.upnpEnabled = upnpEnabled;
    }

    @Value(value="${UpnpPortForwarding.recheckSecs}")
    public void setRecheckSecs(Integer recheckSecs) {
        this.recheckSecs = recheckSecs;
    }

    @Autowired
    @Required
    public void setDaoFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Autowired
    @Required
    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Value(value="${UpnpPortForwarding.skipVerification:false}")
    public void setSkipVerification(boolean skipVerification) {
        this.skipVerification = skipVerification;
    }

    @PostConstruct
    public void initialize() {
        this.sessionDao = this.daoFactory.getSessionDao();
    }

    @Override
    @Scheduled(cron="${UpnpPortForwarding.schedulePattern}")
    public void updateForwardingState() {
        log.trace((Object)"updateForwardingState() started");
        if (!this.upnpEnabled || this.skipVerification) {
            log.trace((Object)"updateForwardingState() - UPNP is disabled");
            return;
        }
        long upnpSetupMinTime = this.recheckSecs * 1000;
        long now = this.systemSupport.currentTimeMillis();
        ArrayList<GatewayDevice> toSetup = new ArrayList<GatewayDevice>();
        Collection<GatewayDevice> devices = this.gatewayDeviceConnection.getAllDevices();
        if (devices == null) {
            return;
        }
        for (GatewayDevice gd : devices) {
            if (!gd.hasUpnpIgd() || !this.sessionDao.isDeviceRegisterd(gd.getMac()) || gd.getUpnpLastCheck() + upnpSetupMinTime >= now) continue;
            if (gd.getUpnpPort() == 0) {
                toSetup.add(gd);
            } else if (!this.upnpApp.forwardingWorks(gd.getMac(), gd.getUpnpPort())) {
                toSetup.add(gd);
            }
            gd.setUpnpLastCheck(now);
        }
        for (GatewayDevice gd : toSetup) {
            this.serviceFactory.getUpnpPortForwardingServiceImpl().setUpForwarding(gd.getMac(), new Integer(gd.getUpnpPort()));
        }
    }
}

