/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.rest.response.HttpProxyVerificationResponse;
import com.vestiacom.gdserver.service.HttpProxyVerificationService;
import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import homemonitor.GatewayDeviceConnection;
import homemonitor.Utility;
import java.nio.ByteBuffer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class HttpProxyVerificationServiceImpl
implements HttpProxyVerificationService {
    private AppServerConnector appServerConnector;
    private String deviceId;
    private long gcSessionId;
    private String gcId;
    private String ldId;
    private String sessionId;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private HttpProxySessions httpProxySessions;

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @Autowired
    @Required
    public void setHttpProxySessions(HttpProxySessions httpProxySessions) {
        this.httpProxySessions = httpProxySessions;
    }

    @Override
    public void verify(String deviceId, long gcSessionId, String gcId, String ldId, String sessionId, GatewayDeviceConnection gatewayDeviceConnection) {
        this.deviceId = deviceId;
        this.gcSessionId = gcSessionId;
        this.gcId = gcId;
        this.ldId = ldId;
        this.sessionId = sessionId;
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        if (this.httpProxySessions.authorize(sessionId)) {
            this.sendResponse(new HttpProxyVerificationResponse("0.0.0.0", 0));
        } else {
            this.sendRequestInNetworkThread();
        }
    }

    private void sendRequestInNetworkThread() {
        new Thread(){

            @Override
            public void run() {
                HttpProxyVerificationResponse response = (HttpProxyVerificationResponse)HttpProxyVerificationServiceImpl.this.appServerConnector.getAsUser(HttpProxyVerificationServiceImpl.this.getRestPath(), HttpProxyVerificationResponse.class, HttpProxyVerificationServiceImpl.this.sessionId);
                HttpProxyVerificationServiceImpl.this.sendResponse(response);
            }
        }.start();
    }

    protected void sendResponse(HttpProxyVerificationResponse response) {
        boolean status = response != null && response.verificationStatus == HttpProxyVerificationResponse.VerificationStatus.SUCCESS;
        ByteBuffer buffer = ByteBuffer.allocate(status ? 8 : 2);
        buffer.putShort((short)(!status ? 1 : 0));
        if (status) {
            buffer.put(Utility.ipAddressToByteArray(response.address));
            buffer.putShort(response.port);
        }
        this.gatewayDeviceConnection.sendSimple(51, this.deviceId, new Long(this.gcSessionId).toString(), buffer.array());
    }

    protected String getRestPath() {
        return "/internal/gd/ld/verifyproxy?deviceId=" + this.deviceId + "&gcId=" + this.gcId + "&ldId=" + this.ldId;
    }
}

