/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.service.impl.DomainNameServiceImpl;
import com.vestiacom.gdserver.service.impl.DomainNameValue;
import com.vestiacom.util.SharedCache;
import java.util.concurrent.ConcurrentMap;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DomainNameServiceImpl.class, DomainNameValue.class})
public class DomainNameServiceImplTests {
    private DomainNameServiceImpl service;
    private SharedCache sharedCache;
    private DaoFactory daoFactory;
    private ConcurrentMap<Object, Object> domainNames;

    @Before
    public void setUp() {
        this.service = new DomainNameServiceImpl();
        this.sharedCache = (SharedCache)PowerMock.createMock(SharedCache.class);
        this.service.setSharedCache(this.sharedCache);
        this.daoFactory = (DaoFactory)PowerMock.createMock(DaoFactory.class);
        this.service.setDaoFactory(this.daoFactory);
    }

    @Test
    public void testAddSuccessfully() throws Exception {
        String name = "testName";
        String mac = "testMac";
        DomainName.AddressType type = DomainName.AddressType.PUBLIC;
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        PowerMock.expectNew(DomainNameValue.class, (Object[])new Object[]{mac, type}).andReturn((Object)value);
        EasyMock.expect((Object)this.domainNames.put(name, value)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.add(name, mac, type);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testAddNoType() throws Exception {
        String name = "testName";
        String mac = "testMac";
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.add(name, mac, null);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testAddNoMac() throws Exception {
        String name = "testName";
        DomainName.AddressType type = DomainName.AddressType.PUBLIC;
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.add(name, null, type);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testAddNoName() throws Exception {
        String mac = "testMac";
        DomainName.AddressType type = DomainName.AddressType.PUBLIC;
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.add(null, mac, type);
        PowerMock.verifyAll();
    }

    @Test
    public void testGet() {
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        DomainNameValue actual = this.service.get(name);
        Assert.assertEquals((Object)value, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testGetNoName() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.get(null);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveSuccessfully() {
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        EasyMock.expect(this.domainNames.remove(name)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        this.service.remove(name);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNoName() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.remove(null);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveSuccessfullyWithDotAtEnd() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)((Object)value.getType())).andReturn((Object)DomainName.AddressType.LOCAL).times(2);
        EasyMock.expect((Object)session.getLocalIp()).andReturn((Object)"testIpAddress");
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals((Object)"testIpAddress", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveSuccessfullyWithNoDotAtEnd() {
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)((Object)value.getType())).andReturn((Object)DomainName.AddressType.LOCAL).times(2);
        EasyMock.expect((Object)session.getLocalIp()).andReturn((Object)"testIpAddress");
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(name);
        Assert.assertEquals((Object)"testIpAddress", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveSuccessfullyLocalAddressType() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)((Object)value.getType())).andReturn((Object)DomainName.AddressType.LOCAL).times(2);
        EasyMock.expect((Object)session.getLocalIp()).andReturn((Object)"testIpAddress");
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals((Object)"testIpAddress", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveSuccessfullyPublicAddressType() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)((Object)value.getType())).andReturn((Object)DomainName.AddressType.PUBLIC).times(2);
        EasyMock.expect((Object)session.getPublicIp()).andReturn((Object)"testIpAddress");
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals((Object)"testIpAddress", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveSuccessfullyNullAddressType() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)((Object)value.getType())).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals(null, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveNoSessionFound() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNames.get(name)).andReturn((Object)value);
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        String mac = "testMac";
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac).times(2);
        EasyMock.expect((Object)sessionDao.get(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals(null, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testResolveNoValueFound() {
        String dotName = "testName.";
        String name = "testName";
        this.domainNames = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect(this.sharedCache.getMap("dns")).andReturn(this.domainNames);
        EasyMock.expect(this.domainNames.get(name)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        String actual = this.service.resolve(dotName);
        Assert.assertEquals(null, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testResolveNoName() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.resolve(null);
        PowerMock.verifyAll();
    }
}

