/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.service.impl.ConnectionCallbacks;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ConnectionCallbacks.class, Utils.class})
public class ConnectionCallbacksTests {
    private ConnectionCallbacks callbacks;
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private GatewayDeviceConnection connection;
    private AppServerConnector appServerConnector;
    private ThreadPoolTaskExecutor taskExecutor;

    @Before
    public void setUp() {
        this.callbacks = new ConnectionCallbacks();
        this.daoFactory = (DaoFactory)PowerMock.createMock(DaoFactory.class);
        this.callbacks.setDaoFactory(this.daoFactory);
        this.connection = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.callbacks.setConnection(this.connection);
        this.appServerConnector = (AppServerConnector)PowerMock.createMock(AppServerConnector.class);
        this.callbacks.setAppServerConnector(this.appServerConnector);
        this.taskExecutor = (ThreadPoolTaskExecutor)PowerMock.createMock(ThreadPoolTaskExecutor.class);
        this.callbacks.setTaskExecutor(this.taskExecutor);
    }

    @Test
    public void testInitializeBatchDisabled() {
        SessionDao sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)sessionDao);
        this.connection.addListener(this.callbacks);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectd() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String localIpAddress = "192.168.21.127";
        String restUrl = "http://cs1.homemonitor.com";
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.connected(mac, publicIpAddress, localIpAddress, restUrl);
    }

    @Test
    public void testHandleConnectdWithoutPreviousSession() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String localIpAddress = "192.168.21.127";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.connection.findById(mac)).andReturn((Object)device);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn(null);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        PowerMock.expectNew(SessionEntity.class, (Object[])new Object[0]).andReturn((Object)session);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIpAddress);
        session.setPublicIp(publicIpAddress);
        EasyMock.expect((Object)device.getLocalIpAddress()).andReturn((Object)localIpAddress);
        session.setLocalIp(localIpAddress);
        session.setServerUrl(restUrl);
        session.setRegistered(null);
        this.sessionDao.store(mac, session);
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.CONNECTED, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.LOCAL_IP_ADDRESS, localIpAddress);
        msg.setParam(Message.Param.REST_URL, restUrl);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleConnected(mac, publicIpAddress, localIpAddress, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectdWithPreviousSessionAndUnknownRegisterdStatus() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String localIpAddress = "192.168.21.127";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.connection.findById(mac)).andReturn((Object)device);
        SessionEntity foundSession = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn((Object)foundSession);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn(null);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        PowerMock.expectNew(SessionEntity.class, (Object[])new Object[0]).andReturn((Object)session);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIpAddress);
        session.setPublicIp(publicIpAddress);
        EasyMock.expect((Object)device.getLocalIpAddress()).andReturn((Object)localIpAddress);
        session.setLocalIp(localIpAddress);
        session.setServerUrl(restUrl);
        session.setRegistered(null);
        this.sessionDao.store(mac, session);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn(null).times(2);
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.CONNECTED, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.LOCAL_IP_ADDRESS, localIpAddress);
        msg.setParam(Message.Param.REST_URL, restUrl);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleConnected(mac, publicIpAddress, localIpAddress, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectdWithPreviousSessionAndRegisterd() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String localIpAddress = "192.168.21.127";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.connection.findById(mac)).andReturn((Object)device);
        SessionEntity foundSession = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn((Object)foundSession);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn((Object)true);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        PowerMock.expectNew(SessionEntity.class, (Object[])new Object[0]).andReturn((Object)session);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIpAddress);
        session.setPublicIp(publicIpAddress);
        EasyMock.expect((Object)device.getLocalIpAddress()).andReturn((Object)localIpAddress);
        session.setLocalIp(localIpAddress);
        session.setServerUrl(restUrl);
        session.setRegistered(true);
        this.sessionDao.store(mac, session);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn((Object)true).times(2);
        EasyMock.expect((Object)foundSession.isRegistered()).andReturn((Object)true);
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.CONNECTED, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.LOCAL_IP_ADDRESS, localIpAddress);
        msg.setParam(Message.Param.REST_URL, restUrl);
        msg.setParam(Message.Param.REGISTERED, "true");
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleConnected(mac, publicIpAddress, localIpAddress, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectdWithPreviousSessionAndNotRegisterd() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String localIpAddress = "192.168.21.127";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.connection.findById(mac)).andReturn((Object)device);
        SessionEntity foundSession = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn((Object)foundSession);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn((Object)true);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        PowerMock.expectNew(SessionEntity.class, (Object[])new Object[0]).andReturn((Object)session);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIpAddress);
        session.setPublicIp(publicIpAddress);
        EasyMock.expect((Object)device.getLocalIpAddress()).andReturn((Object)localIpAddress);
        session.setLocalIp(localIpAddress);
        session.setServerUrl(restUrl);
        session.setRegistered(true);
        this.sessionDao.store(mac, session);
        EasyMock.expect((Object)foundSession.getRegistered()).andReturn((Object)true);
        EasyMock.expect((Object)foundSession.isRegistered()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleConnected(mac, publicIpAddress, localIpAddress, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnected() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String reason = "disconnectedReason";
        String restUrl = "http://cs1.homemonitor.com";
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.disconnected(mac, publicIpAddress, reason, restUrl);
    }

    @Test
    public void testHandleDisconnectedRegistered() throws Exception {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String reason = "disconnectedReason";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        this.sessionDao.disconnected(mac, restUrl);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)session.isRegistered()).andReturn((Object)true);
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.DISCONNECTED, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.PUBLIC_IP_ADDRESS, publicIpAddress);
        msg.setParam(Message.Param.REASON, reason);
        msg.setParam(Message.Param.REST_URL, restUrl);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleDisconnected(mac, publicIpAddress, reason, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleDisconnectedNotRegistered() {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String reason = "disconnectedReason";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        this.sessionDao.disconnected(mac, restUrl);
        SessionEntity session = (SessionEntity)PowerMock.createMock(SessionEntity.class);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn((Object)session);
        EasyMock.expect((Object)session.isRegistered()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleDisconnected(mac, publicIpAddress, reason, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedWithNoSessionAndBatchDisabled() {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String reason = "disconnectedReason";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        this.sessionDao.disconnected(mac, restUrl);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleDisconnected(mac, publicIpAddress, reason, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedWithNoSessionAndBatchEnabled() {
        String mac = "00:00:00:00:00:00";
        String publicIpAddress = "83.238.166.108";
        String reason = "disconnectedReason";
        String restUrl = "http://cs1.homemonitor.com";
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        this.connection.addListener(this.callbacks);
        this.sessionDao.disconnected(mac, restUrl);
        EasyMock.expect((Object)this.sessionDao.get(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.initialize();
        this.callbacks.handleDisconnected(mac, publicIpAddress, reason, restUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogs() throws Exception {
        String mac = "00:00:00:00:00:00";
        String logs = "some logs from gatewaclient";
        this.taskExecutor.execute((Runnable)EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.receivedLogs(mac, logs);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleReceivedLogs() throws Exception {
        String mac = "00:00:00:00:00:00";
        String logs = "some logs from gatewaclient";
        Message msg = (Message)PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, (Object[])new Object[]{Message.Type.LOGS, mac}).andReturn((Object)msg);
        msg.setParam(Message.Param.VALUE, logs);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll((Object[])new Object[0]);
        this.callbacks.handleReceivedLogs(mac, logs);
        PowerMock.verifyAll();
    }
}

