/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.RestFilter;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RestFilter.class, Utils.class, Response.class, Gson.class})
public class RestFilterTests {
    private RestFilter restFilter;
    private GatewayDeviceConnection deviceConnection;

    @Before
    public void setUp() {
        this.restFilter = new RestFilter();
        this.deviceConnection = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.restFilter.setDeviceConnection(this.deviceConnection);
        PowerMock.mockStatic(Utils.class);
    }

    @Test
    public void testDoFilterDeviceConnectedWithMacWithoutSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = (ServletResponse)PowerMock.createMock(ServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(mac)).andReturn((Object)device);
        chain.doFilter((ServletRequest)request, response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithMacWithSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = (ServletResponse)PowerMock.createMock(ServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac + "/someAdditionalData";
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(mac)).andReturn((Object)device);
        chain.doFilter((ServletRequest)request, response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithHaidWithoutSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = (ServletResponse)PowerMock.createMock(ServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String haid = "43299c50-794d-11e3-981f-0800200c9a66";
        String uri = "/device/" + haid;
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haid)).andReturn((Object)device);
        chain.doFilter((ServletRequest)request, response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceConnectedWithHaidWithSubsequentSlash() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = (ServletResponse)PowerMock.createMock(ServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String haid = "43299c50-794d-11e3-981f-0800200c9a66";
        String uri = "/device/" + haid + "/someAdditionalData";
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haid)).andReturn((Object)device);
        chain.doFilter((ServletRequest)request, response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceAnotherNodeConnected() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        ServletResponse response = (ServletResponse)PowerMock.createMock(ServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        EasyMock.expect((Object)this.deviceConnection.findById(mac)).andReturn(null);
        String deviceHost = "deviceHost";
        EasyMock.expect((Object)this.deviceConnection.getServerUrl(mac)).andReturn((Object)deviceHost);
        Response restResponse = (Response)PowerMock.createMock(Response.class);
        PowerMock.expectNew(Response.class, (Object[])new Object[]{deviceHost}).andReturn((Object)restResponse);
        response.setContentType("application/json");
        Gson gson = (Gson)PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, (Object[])new Object[0]).andReturn((Object)gson);
        String jsonResponse = "jsonResponse";
        EasyMock.expect((Object)gson.toJson((Object)restResponse)).andReturn((Object)jsonResponse);
        PrintWriter writer = (PrintWriter)PowerMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)response.getWriter()).andReturn((Object)writer);
        writer.println(jsonResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDeviceClusterNotConnected() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac;
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(2);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        EasyMock.expect((Object)this.deviceConnection.findById(mac)).andReturn(null);
        EasyMock.expect((Object)this.deviceConnection.getServerUrl(mac)).andReturn(null);
        Response restResponse = (Response)PowerMock.createMock(Response.class);
        PowerMock.expectNew(Response.class, (Object[])new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn((Object)restResponse);
        response.setContentType("application/json");
        Gson gson = (Gson)PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, (Object[])new Object[0]).andReturn((Object)gson);
        String jsonResponse = "jsonResponse";
        EasyMock.expect((Object)gson.toJson((Object)restResponse)).andReturn((Object)jsonResponse);
        PrintWriter writer = (PrintWriter)PowerMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)response.getWriter()).andReturn((Object)writer);
        writer.println(jsonResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterInvalidPath() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:000";
        String uri = "/devic/" + mac;
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(3);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)false);
        response.sendError(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterBlankUri() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String uri = "";
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri).times(3);
        EasyMock.expect((Object)Utils.isBlank(uri)).andReturn((Object)true);
        response.sendError(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterServerUrlRequest() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        String mac = "00:00:00:00:00:00";
        String uri = "/device/" + mac + "/serverUrl";
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)uri);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }
}

