/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.vestiacom.gdserver.GDServer;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.rest.RESTService;
import com.vestiacom.gdserver.rest.model.DiscoverDeviceResponse;
import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import com.vestiacom.gdserver.rest.model.Make;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.ConfigureLoggerResponse;
import com.vestiacom.gdserver.rest.response.CreateTcpProxyResponse;
import com.vestiacom.gdserver.rest.response.DiscoverCameraIpAddressResponse;
import com.vestiacom.gdserver.rest.response.ExecuteCommandResponse;
import com.vestiacom.gdserver.rest.response.ExecuteHttpCommandResponse;
import com.vestiacom.gdserver.rest.response.ForceUpgradeResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.GetDeviceResponse;
import com.vestiacom.gdserver.rest.response.GetDeviceServerUrlResponse;
import com.vestiacom.gdserver.rest.response.GetDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GetVersionResponse;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SearchCandidatesResponse;
import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import com.vestiacom.gdserver.service.DomainNameService;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.TestService;
import com.vestiacom.gdserver.service.VivotekCameraIpAddressDiscoveryService;
import com.vestiacom.gdserver.service.impl.DomainNameValue;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDeviceConnection;
import homemonitor.HTTPClient.HTTPClientService;
import homemonitor.ICETransport.Candidates;
import homemonitor.ICETransport.IceTransportService;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.TCPProxy.TCPProxyApp;
import homemonitor.execcmd.CmdResult;
import homemonitor.execcmd.ExecCmdService;
import homemonitor.logs.LoggerConfiguratorService;
import homemonitor.tcpclient.TCPClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RESTService.class, Utils.class, GetDeviceResponse.class, GetDeviceServerUrlResponse.class, ForceUpgradeResponse.class, ExecuteCommandResponse.class, CommandResult.class, SearchCandidatesResponse.class, URL.class, ExecuteHttpCommandResponse.class, Base64.class, ConfigureLoggerResponse.class, DiscoverCameraIpAddressResponse.class, DiscoverDeviceResponse.class, Make.class, SetUpUpnpForwardingResponse.class, SetRegisteredResponse.class, AddDomainNameResponse.class, GetDomainNameResponse.class, DomainName.class, RemoveDomainNameResponse.class, GetVersionResponse.class, GDServer.class})
public class RESTServiceTest {
    private RESTService restService;
    private TestService testService;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private TCPProxy tcpProxy;
    private TCPClient tcpClient;
    private ServiceFactory serviceFactory;
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private DomainNameService domainNameService;
    private AppServerConnector appServerConnector;

    @Before
    public void setUp() {
        this.restService = new RESTService();
        this.testService = (TestService)PowerMock.createMock(TestService.class);
        this.restService.setTestService(this.testService);
        this.gatewayDeviceConnection = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.restService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.tcpProxy = (TCPProxy)PowerMock.createMock(TCPProxy.class);
        this.restService.setTcpProxy(this.tcpProxy);
        this.tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        this.restService.setTcpClient(this.tcpClient);
        this.serviceFactory = (ServiceFactory)PowerMock.createMock(ServiceFactory.class);
        this.restService.setServiceFactory(this.serviceFactory);
        this.daoFactory = (DaoFactory)PowerMock.createMock(DaoFactory.class);
        this.restService.setDaoFactory(this.daoFactory);
        this.sessionDao = (SessionDao)PowerMock.createMock(SessionDao.class);
        this.restService.setSessionDao(this.sessionDao);
        this.domainNameService = (DomainNameService)PowerMock.createMock(DomainNameService.class);
        this.restService.setDomainNameService(this.domainNameService);
        this.appServerConnector = (AppServerConnector)PowerMock.createMock(AppServerConnector.class);
        this.restService.setAppServerConnector(this.appServerConnector);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(Base64.class);
        PowerMock.mockStatic(Make.class);
    }

    @Test
    public void testInitialize() {
        EasyMock.expect((Object)this.daoFactory.getSessionDao()).andReturn((Object)this.sessionDao);
        PowerMock.replayAll((Object[])new Object[0]);
        this.restService.initialize();
        PowerMock.verifyAll();
    }

    @Test
    public void testTestHttpClinet() {
        EasyMock.expect((Object)this.testService.testhttpClient()).andReturn((Object)"testResponse");
        PowerMock.replayAll((Object[])new Object[0]);
        this.restService.testhttpClient();
        PowerMock.verifyAll();
    }

    @Test
    public void testProxy() {
        String mac = "testMac";
        String url = "testUrl";
        EasyMock.expect((Object)this.testService.proxy(mac, url)).andReturn((Object)"testResponse");
        PowerMock.replayAll((Object[])new Object[0]);
        this.restService.proxy(mac, url);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        homemonitor.GatewayDevice device = (homemonitor.GatewayDevice)PowerMock.createMock(homemonitor.GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(deviceId)).andReturn((Object)device);
        GatewayDevice model = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        PowerMock.expectNew(GatewayDevice.class, (Object[])new Object[0]).andReturn((Object)model);
        String mac = "testMac";
        String publicIpAddress = "testPublicIpAddress";
        String localIpAddress = "testLocalIpAddress";
        int versionMajor = 1;
        int versionMinor = 2;
        int buildNo = 123;
        int deviceType = 3;
        long lastAlive = 12345L;
        Date connectedDate = new Date();
        boolean encryptedControlConnection = true;
        boolean gateway = false;
        boolean embedded = true;
        boolean nas = false;
        boolean stargate = false;
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        model.setMac(mac);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)publicIpAddress);
        model.setPublicIpAddress(publicIpAddress);
        EasyMock.expect((Object)device.getLocalIpAddress()).andReturn((Object)localIpAddress);
        model.setLocalIpAddress(localIpAddress);
        EasyMock.expect((Object)device.getVersionMajor()).andReturn((Object)versionMajor);
        model.setVersionMajor(versionMajor);
        EasyMock.expect((Object)device.getVersionMinor()).andReturn((Object)versionMinor);
        model.setVersionMinor(versionMinor);
        EasyMock.expect((Object)device.getBuildNo()).andReturn((Object)buildNo);
        model.setBuildNo(buildNo);
        EasyMock.expect((Object)device.getDeviceType()).andReturn((Object)deviceType);
        model.setDeviceType(deviceType);
        EasyMock.expect((Object)device.getLastAlive()).andReturn((Object)lastAlive);
        model.setLastAlive(lastAlive);
        EasyMock.expect((Object)device.getConnectedDate()).andReturn((Object)connectedDate);
        model.setConnectedDate(connectedDate);
        EasyMock.expect((Object)device.isEncryptedControlConnection()).andReturn((Object)encryptedControlConnection);
        model.setEncryptedControlConnection(encryptedControlConnection);
        EasyMock.expect((Object)device.isGateway()).andReturn((Object)gateway);
        model.setGateway(gateway);
        EasyMock.expect((Object)device.isEmbedded()).andReturn((Object)embedded);
        model.setEmbedded(embedded);
        EasyMock.expect((Object)device.isNAS()).andReturn((Object)nas);
        model.setNas(nas);
        EasyMock.expect((Object)device.isStargate()).andReturn((Object)stargate);
        model.setStargate(stargate);
        GetDeviceResponse response = (GetDeviceResponse)PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, (Object[])new Object[]{model}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceAnotherNodeConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        String deviceServerUrl = "testdeviceServerUrl";
        EasyMock.expect((Object)this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn((Object)deviceServerUrl);
        GetDeviceResponse response = (GetDeviceResponse)PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, (Object[])new Object[]{deviceServerUrl}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceClusterNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        EasyMock.expect((Object)this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(null);
        GetDeviceResponse response = (GetDeviceResponse)PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, (Object[])new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceNoDeviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        GetDeviceResponse response = (GetDeviceResponse)PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, (Object[])new Object[]{GetDeviceResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        String deviceServerUrl = "testDeviceServerUrl";
        EasyMock.expect((Object)this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn((Object)deviceServerUrl);
        GetDeviceServerUrlResponse response = (GetDeviceServerUrlResponse)PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, (Object[])new Object[]{deviceServerUrl}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlClusterNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(null);
        GetDeviceServerUrlResponse response = (GetDeviceServerUrlResponse)PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, (Object[])new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlNoDviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        GetDeviceServerUrlResponse response = (GetDeviceServerUrlResponse)PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, (Object[])new Object[]{GetDeviceServerUrlResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        homemonitor.GatewayDevice device = (homemonitor.GatewayDevice)PowerMock.createMock(homemonitor.GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(deviceId)).andReturn((Object)device);
        this.gatewayDeviceConnection.forceUpgrade(deviceId);
        ForceUpgradeResponse response = (ForceUpgradeResponse)PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, (Object[])new Object[]{Response.Status.SUCCESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeDeviceNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        ForceUpgradeResponse response = (ForceUpgradeResponse)PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, (Object[])new Object[]{ForceUpgradeResponse.ErrorCode.DEVICE_NOT_CONNECTED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeNoDeviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        ForceUpgradeResponse response = (ForceUpgradeResponse)PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, (Object[])new Object[]{ForceUpgradeResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdSucccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(command)).andReturn((Object)false);
        ExecCmdService cmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService(timeout)).andReturn((Object)cmdService);
        CmdResult cmdResult = (CmdResult)PowerMock.createMock(CmdResult.class);
        EasyMock.expect((Object)cmdService.executeCommand(deviceId, command)).andReturn((Object)cmdResult);
        CommandResult commandResult = (CommandResult)PowerMock.createMock(CommandResult.class);
        EasyMock.expect((Object)cmdResult.getOutput()).andReturn((Object)"testOutput");
        EasyMock.expect((Object)cmdResult.getStatusCode()).andReturn((Object)1);
        PowerMock.expectNew(CommandResult.class, (Object[])new Object[]{"testOutput", 1}).andReturn((Object)commandResult);
        ExecuteCommandResponse response = (ExecuteCommandResponse)PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, (Object[])new Object[]{Response.Status.SUCCESS, commandResult}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdFailure() throws Exception {
        String deviceId = "testDeviceId";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(command)).andReturn((Object)false);
        ExecCmdService cmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService(timeout)).andReturn((Object)cmdService);
        EasyMock.expect((Object)cmdService.executeCommand(deviceId, command)).andReturn(null);
        ExecuteCommandResponse response = (ExecuteCommandResponse)PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, (Object[])new Object[]{Response.Status.FAILURE}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdBlankCommand() throws Exception {
        String deviceId = "testDeviceId";
        String command = "";
        Long timeout = 10000L;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(command)).andReturn((Object)true);
        ExecuteCommandResponse response = (ExecuteCommandResponse)PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, (Object[])new Object[]{ExecuteCommandResponse.ErrorCode.NO_COMMAND}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdBlankDeviceId() throws Exception {
        String deviceId = "";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        ExecuteCommandResponse response = (ExecuteCommandResponse)PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, (Object[])new Object[]{ExecuteCommandResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(candidates)).andReturn((Object)false);
        IceTransportService iceTransportService = (IceTransportService)PowerMock.createMock(IceTransportService.class);
        EasyMock.expect((Object)this.serviceFactory.getIceTransportService()).andReturn((Object)iceTransportService);
        Candidates foundCandidates = (Candidates)PowerMock.createMock(Candidates.class);
        EasyMock.expect((Object)iceTransportService.execute(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates)).andReturn((Object)foundCandidates);
        String cand = "!@#$%^";
        Integer startPort = 1;
        Integer endPort = 9;
        EasyMock.expect((Object)foundCandidates.getCandidates()).andReturn((Object)cand);
        EasyMock.expect((Object)foundCandidates.getPortRangeStart()).andReturn((Object)startPort);
        EasyMock.expect((Object)foundCandidates.getPortRangeEnd()).andReturn((Object)endPort);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{cand, startPort, endPort}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesFailure() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(candidates)).andReturn((Object)false);
        IceTransportService iceTransportService = (IceTransportService)PowerMock.createMock(IceTransportService.class);
        EasyMock.expect((Object)this.serviceFactory.getIceTransportService()).andReturn((Object)iceTransportService);
        EasyMock.expect((Object)iceTransportService.execute(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates)).andReturn(null);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.ERROR}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankCanidates() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(candidates)).andReturn((Object)true);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_CONDIDATES}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnPass() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = null;
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_PASS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnUser() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = null;
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_USER}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnPort() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = null;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_PORT}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnAddr() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = null;
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_ADDR}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullStunPort() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = null;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)false);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_STUN_PORT}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankStunAddr() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = " ";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(stunAddr)).andReturn((Object)true);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_STUN_ADDR}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankDeviceId() throws Exception {
        String deviceId = "";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        SearchCandidatesResponse response = (SearchCandidatesResponse)PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, (Object[])new Object[]{SearchCandidatesResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteGetHttpCommandViaTcpProxySuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.GET;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        URL urlj = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{url}).andReturn((Object)urlj);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, (Object[])new Object[]{this.tcpProxy}).andReturn((Object)httpClientService);
        EasyMock.expect((Object)command.getTimeout()).andReturn((Object)timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect((Object)httpClientService.get(deviceId, urlj)).andReturn((Object)result);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{result}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxySuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        String body = "testBody";
        Map headers = (Map)PowerMock.createMock(Map.class);
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body);
        EasyMock.expect((Object)Utils.isBlank(body)).andReturn((Object)false);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        URL urlj = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{url}).andReturn((Object)urlj);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, (Object[])new Object[]{this.tcpProxy}).andReturn((Object)httpClientService);
        EasyMock.expect((Object)command.getTimeout()).andReturn((Object)timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body).times(2);
        byte[] rawBody = new byte[10];
        EasyMock.expect((Object)Base64.decodeBase64((String)body)).andReturn((Object)rawBody);
        EasyMock.expect(command.getHeaders()).andReturn((Object)headers);
        EasyMock.expect((Object)httpClientService.post(deviceId, urlj, headers, rawBody)).andReturn((Object)result);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{result}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteGetHttpCommandViaTcpClientSuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.GET;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_CLIENT;
        String url = "testUrl";
        Integer timeout = 10;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        URL urlj = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{url}).andReturn((Object)urlj);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, (Object[])new Object[]{this.tcpClient}).andReturn((Object)httpClientService);
        EasyMock.expect((Object)command.getTimeout()).andReturn((Object)timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect((Object)httpClientService.get(deviceId, urlj)).andReturn((Object)result);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{result}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyFailure() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        String body = "testBody";
        Map headers = (Map)PowerMock.createMock(Map.class);
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body);
        EasyMock.expect((Object)Utils.isBlank(body)).andReturn((Object)false);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        URL urlj = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{url}).andReturn((Object)urlj);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, (Object[])new Object[]{this.tcpProxy}).andReturn((Object)httpClientService);
        EasyMock.expect((Object)command.getTimeout()).andReturn((Object)timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body).times(2);
        byte[] rawBody = new byte[10];
        EasyMock.expect((Object)Base64.decodeBase64((String)body)).andReturn((Object)rawBody);
        EasyMock.expect(command.getHeaders()).andReturn((Object)headers);
        EasyMock.expect((Object)httpClientService.post(deviceId, urlj, headers, rawBody)).andReturn(null);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.ERROR}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyMalformedUrl() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        String body = "testBody";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body);
        EasyMock.expect((Object)Utils.isBlank(body)).andReturn((Object)false);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{url}).andThrow((Throwable)new MalformedURLException());
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.MALFORMED_URL}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoBody() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        String body = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod).times(2);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)false);
        EasyMock.expect((Object)command.getBody()).andReturn((Object)body);
        EasyMock.expect((Object)Utils.isBlank(body)).andReturn((Object)true);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_BODY}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoUrl() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn((Object)connectionType);
        EasyMock.expect((Object)command.getUrl()).andReturn((Object)url);
        EasyMock.expect((Object)Utils.isBlank(url)).andReturn((Object)true);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_URL}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoConnectionType() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn((Object)sendMethod);
        EasyMock.expect((Object)((Object)command.getConnectionType())).andReturn(null);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_CONNECTION_TYPE}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoMethod() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = (HttpCommand)PowerMock.createMock(HttpCommand.class);
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)command.getMethod())).andReturn(null);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_METHOD}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoCommand() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_COMMAND}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, null);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoDeviceId() throws Exception {
        String deviceId = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, (Object[])new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, null);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxySuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "testDstAddress";
        Integer dstPort = 2;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(dstAddress)).andReturn((Object)false);
        TCPProxyApp tcpProxyApp = (TCPProxyApp)PowerMock.createMock(TCPProxyApp.class);
        PowerMock.expectNew(TCPProxyApp.class, (Object[])new Object[]{localPort, deviceId, dstAddress, dstPort, this.tcpProxy, null}).andReturn((Object)tcpProxyApp);
        tcpProxyApp.start();
        EasyMock.expect((Object)tcpProxyApp.getLocalPort()).andReturn((Object)localPort);
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, (Object[])new Object[]{localPort}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDstPort() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(dstAddress)).andReturn((Object)false);
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, (Object[])new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DST_PORT}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDstAddress() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "";
        Integer dstPort = 2;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(dstAddress)).andReturn((Object)true);
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, (Object[])new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DST_ADDRESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoLocalPort() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = null;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, (Object[])new Object[]{CreateTcpProxyResponse.ErrorCode.NO_LOCAL_PORT}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDeviceId() throws Exception {
        String deviceId = "";
        Integer localPort = null;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, (Object[])new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String data = "testData";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(data)).andReturn((Object)false);
        LoggerConfiguratorService service = (LoggerConfiguratorService)PowerMock.createMock(LoggerConfiguratorService.class);
        EasyMock.expect((Object)this.serviceFactory.getLoggerConfiguratorService()).andReturn((Object)service);
        LoggerConfigurationStatus status = LoggerConfigurationStatus.SUCCESS;
        EasyMock.expect((Object)((Object)service.configureLogs(deviceId, data))).andReturn((Object)status);
        ConfigureLoggerResponse response = (ConfigureLoggerResponse)PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, (Object[])new Object[]{status}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerNoConfiguration() throws Exception {
        String deviceId = "testDeviceId";
        String data = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(data)).andReturn((Object)true);
        ConfigureLoggerResponse response = (ConfigureLoggerResponse)PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, (Object[])new Object[]{ConfigureLoggerResponse.ErrorCode.NO_LOGGER_CONFIGURATION}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerNoDeviceId() throws Exception {
        String deviceId = "";
        String data = "testData";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        ConfigureLoggerResponse response = (ConfigureLoggerResponse)PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, (Object[])new Object[]{ConfigureLoggerResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpAddressSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        VivotekCameraIpAddressDiscoveryService service = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)this.serviceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)service);
        String discoverdIp = "testDiscoveredIp";
        EasyMock.expect((Object)service.getCameraIpAddress(deviceId, mac)).andReturn((Object)discoverdIp);
        DiscoverCameraIpAddressResponse response = (DiscoverCameraIpAddressResponse)PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, (Object[])new Object[]{discoverdIp}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpNoMac() throws Exception {
        String deviceId = "testDeviceId";
        String mac = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)true);
        DiscoverCameraIpAddressResponse response = (DiscoverCameraIpAddressResponse)PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, (Object[])new Object[]{DiscoverCameraIpAddressResponse.ErrorCode.NO_MAC}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpNoDeviceIp() throws Exception {
        String deviceId = "";
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        DiscoverCameraIpAddressResponse response = (DiscoverCameraIpAddressResponse)PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, (Object[])new Object[]{DiscoverCameraIpAddressResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        Make make = Make.VIVOTEK;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(makeText)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)Make.parse(makeText))).andReturn((Object)make);
        CameraDiscoveryService service = (CameraDiscoveryService)PowerMock.createMock(CameraDiscoveryService.class);
        EasyMock.expect((Object)this.serviceFactory.getCameraDiscoveryService(make)).andReturn((Object)service);
        List devices = (List)PowerMock.createMock(List.class);
        EasyMock.expect(service.discover(deviceId)).andReturn((Object)devices);
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, (Object[])new Object[]{devices}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceFailure() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        Make make = Make.VIVOTEK;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(makeText)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)Make.parse(makeText))).andReturn((Object)make);
        EasyMock.expect((Object)this.serviceFactory.getCameraDiscoveryService(make)).andReturn(null);
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, (Object[])new Object[]{DiscoverDeviceResponse.ErrorCode.ERROR}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceInvalidMake() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(makeText)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)Make.parse(makeText))).andReturn(null);
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, (Object[])new Object[]{DiscoverDeviceResponse.ErrorCode.INVALID_MAKE}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceNoMake() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(makeText)).andReturn((Object)true);
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, (Object[])new Object[]{DiscoverDeviceResponse.ErrorCode.NO_MAKE}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceNoDeviceId() throws Exception {
        String deviceId = "";
        String makeText = "vivotek";
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, (Object[])new Object[]{DiscoverDeviceResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Integer upnpPort = 0;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        UpnpPortForwardingServiceImpl service = (UpnpPortForwardingServiceImpl)PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect((Object)this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn((Object)service);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)service.setUpForwarding(deviceId, upnpPort)).andReturn((Object)result);
        SetUpUpnpForwardingResponse response = (SetUpUpnpForwardingResponse)PowerMock.createMock(SetUpUpnpForwardingResponse.class);
        PowerMock.expectNew(SetUpUpnpForwardingResponse.class, (Object[])new Object[]{result}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse actual = this.restService.setUpUpnpForwarding(deviceId, upnpPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingNoDeviceId() throws Exception {
        String deviceId = "";
        Integer upnpPort = 0;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        SetUpUpnpForwardingResponse response = (SetUpUpnpForwardingResponse)PowerMock.createMock(SetUpUpnpForwardingResponse.class);
        PowerMock.expectNew(SetUpUpnpForwardingResponse.class, (Object[])new Object[]{SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SetUpUpnpForwardingResponse actual = this.restService.setUpUpnpForwarding(deviceId, upnpPort);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Boolean registered = true;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        this.sessionDao.registered(deviceId, registered);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredNoRegiteredStatus() throws Exception {
        String deviceId = "testDeviceId";
        Boolean registered = null;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)false);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, (Object[])new Object[]{SetRegisteredResponse.ErrorCode.NO_REGISTERED_STATUS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredNoDeviceId() throws Exception {
        String deviceId = "";
        Boolean registered = true;
        EasyMock.expect((Object)Utils.isBlank(deviceId)).andReturn((Object)true);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, (Object[])new Object[]{SetRegisteredResponse.ErrorCode.NO_DEVICE_ID}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameSuccessfully() throws Exception {
        DomainName data = (DomainName)PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "testMac";
        DomainName.AddressType addressType = DomainName.AddressType.PUBLIC;
        EasyMock.expect((Object)data.getName()).andReturn((Object)name).times(2);
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        EasyMock.expect((Object)data.getMac()).andReturn((Object)mac).times(2);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)data.getType())).andReturn((Object)addressType).times(2);
        this.domainNameService.add(name, mac, addressType);
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, (Object[])new Object[]{Response.Status.SUCCESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoType() throws Exception {
        DomainName data = (DomainName)PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "testMac";
        Object addressType = null;
        EasyMock.expect((Object)data.getName()).andReturn((Object)name);
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        EasyMock.expect((Object)data.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)false);
        EasyMock.expect((Object)((Object)data.getType())).andReturn(addressType);
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, (Object[])new Object[]{AddDomainNameResponse.ErrorCode.NO_TYPE}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoMac() throws Exception {
        DomainName data = (DomainName)PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "";
        EasyMock.expect((Object)data.getName()).andReturn((Object)name);
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        EasyMock.expect((Object)data.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)true);
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, (Object[])new Object[]{AddDomainNameResponse.ErrorCode.NO_MAC}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoName() throws Exception {
        DomainName data = (DomainName)PowerMock.createMock(DomainName.class);
        String name = "";
        EasyMock.expect((Object)data.getName()).andReturn((Object)name);
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)true);
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, (Object[])new Object[]{AddDomainNameResponse.ErrorCode.NO_NAME}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameSuccessfully() throws Exception {
        String name = "testName";
        String mac = "testMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        DomainNameValue value = (DomainNameValue)PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect((Object)this.domainNameService.get(name)).andReturn((Object)value);
        GetDomainNameResponse response = (GetDomainNameResponse)PowerMock.createMock(GetDomainNameResponse.class);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        EasyMock.expect((Object)value.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)((Object)value.getType())).andReturn((Object)type);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{name, mac, type}).andReturn((Object)domainName);
        PowerMock.expectNew(GetDomainNameResponse.class, (Object[])new Object[]{Response.Status.SUCCESS, domainName}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameNotFound() throws Exception {
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        EasyMock.expect((Object)this.domainNameService.get(name)).andReturn(null);
        GetDomainNameResponse response = (GetDomainNameResponse)PowerMock.createMock(GetDomainNameResponse.class);
        PowerMock.expectNew(GetDomainNameResponse.class, (Object[])new Object[]{Response.Status.SUCCESS, null}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameNoName() throws Exception {
        String name = "";
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)true);
        GetDomainNameResponse response = (GetDomainNameResponse)PowerMock.createMock(GetDomainNameResponse.class);
        PowerMock.expectNew(GetDomainNameResponse.class, (Object[])new Object[]{GetDomainNameResponse.ErrorCode.NO_NAME}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDomainNameSuccessfully() throws Exception {
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)false);
        this.domainNameService.remove(name);
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        PowerMock.expectNew(RemoveDomainNameResponse.class, (Object[])new Object[]{Response.Status.SUCCESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveDomainNameResponse actual = this.restService.removeDomainName(name);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDomainNameNoName() throws Exception {
        String name = "";
        EasyMock.expect((Object)Utils.isBlank(name)).andReturn((Object)true);
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        PowerMock.expectNew(RemoveDomainNameResponse.class, (Object[])new Object[]{RemoveDomainNameResponse.ErrorCode.NO_NAME}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveDomainNameResponse actual = this.restService.removeDomainName(name);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }
}

