/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.GDServer;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.DiscoverDeviceResponse;
import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.model.Make;
import com.vestiacom.gdserver.rest.model.RegisteredBatch;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.ConfigureLoggerResponse;
import com.vestiacom.gdserver.rest.response.CreateTcpProxyResponse;
import com.vestiacom.gdserver.rest.response.DiscoverCameraIpAddressResponse;
import com.vestiacom.gdserver.rest.response.ExecuteCommandResponse;
import com.vestiacom.gdserver.rest.response.ExecuteHttpCommandResponse;
import com.vestiacom.gdserver.rest.response.ForceUpgradeResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.GetDeviceResponse;
import com.vestiacom.gdserver.rest.response.GetDeviceServerUrlResponse;
import com.vestiacom.gdserver.rest.response.GetDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GetVersionResponse;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SearchCandidatesResponse;
import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import com.vestiacom.gdserver.service.DomainNameService;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.TestService;
import com.vestiacom.gdserver.service.VivotekCameraIpAddressDiscoveryService;
import com.vestiacom.gdserver.service.impl.ConnectionCallbacks;
import com.vestiacom.gdserver.service.impl.DomainNameValue;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDeviceConnection;
import homemonitor.HTTPClient.HTTPClientService;
import homemonitor.ICETransport.Candidates;
import homemonitor.ICETransport.IceTransportService;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.TCPProxy.TCPProxyApp;
import homemonitor.execcmd.CmdResult;
import homemonitor.execcmd.ExecCmdService;
import homemonitor.logs.LoggerConfiguratorService;
import homemonitor.tcpclient.TCPClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Path(value="/")
@Produces(value={"application/json"})
@Service
public class RESTService {
    private static Logger log = Logger.getLogger(RESTService.class);
    private TestService testService;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private TCPProxy tcpProxy;
    private TCPClient tcpClient;
    private ServiceFactory serviceFactory;
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private DomainNameService domainNameService;
    private AppServerConnector appServerConnector;
    ConnectionCallbacks connectionCollbacks;
    private String restUrl;

    @Autowired
    @Required
    public void setTestService(TestService testService) {
        this.testService = testService;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnection gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Autowired
    @Required
    public void setTcpProxy(TCPProxy tcpProxy) {
        this.tcpProxy = tcpProxy;
    }

    @Autowired
    @Required
    public void setTcpClient(TCPClient tcpClient) {
        this.tcpClient = tcpClient;
    }

    @Autowired
    @Required
    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Autowired
    @Required
    public void setDaoFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Autowired
    @Required
    public void setDomainNameService(DomainNameService domainNameService) {
        this.domainNameService = domainNameService;
    }

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @PostConstruct
    public void initialize() {
        this.sessionDao = this.daoFactory.getSessionDao();
    }

    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Path(value="/httpclienttest")
    @GET
    public String testhttpClient() {
        return this.testService.testhttpClient();
    }

    @GET
    @Path(value="/proxy/{gcMac}")
    public String proxy(@PathParam(value="gcMac") String gcMac, @QueryParam(value="url") String strUrl) {
        log.debug((Object)("start proxy(gcMac=" + gcMac + ", url=" + strUrl + ")"));
        return this.testService.proxy(gcMac, strUrl);
    }

    @GET
    @Path(value="/device/{deviceId}")
    public GetDeviceResponse getDevice(@PathParam(value="deviceId") String deviceId) {
        log.debug((Object)("start getDevice(id=" + deviceId + ")"));
        if (Utils.isBlank(deviceId)) {
            return new GetDeviceResponse(GetDeviceResponse.ErrorCode.NO_DEVICE_ID);
        }
        homemonitor.GatewayDevice device = this.gatewayDeviceConnection.findById(deviceId);
        if (device == null) {
            String serverUrl = this.gatewayDeviceConnection.getServerUrl(deviceId);
            if (serverUrl == null) {
                return new GetDeviceResponse(Response.Status.CLUSTER_NOT_CONNECTED);
            }
            return new GetDeviceResponse(serverUrl);
        }
        return new GetDeviceResponse(this.toModel(device));
    }

    @GET
    @Path(value="/device/{deviceId}/serverUrl")
    public GetDeviceServerUrlResponse getDeviceServerUrl(@PathParam(value="deviceId") String deviceId) {
        log.debug((Object)("start getDeviceServerUrl(deviceId=" + deviceId + ")"));
        if (Utils.isBlank(deviceId)) {
            return new GetDeviceServerUrlResponse(GetDeviceServerUrlResponse.ErrorCode.NO_DEVICE_ID);
        }
        String serverUrl = this.gatewayDeviceConnection.getServerUrl(deviceId);
        if (serverUrl == null) {
            return new GetDeviceServerUrlResponse(Response.Status.CLUSTER_NOT_CONNECTED);
        }
        return new GetDeviceServerUrlResponse(serverUrl);
    }

    private GatewayDevice toModel(homemonitor.GatewayDevice device) {
        if (device == null) {
            return null;
        }
        GatewayDevice model = new GatewayDevice();
        model.setMac(device.getMac());
        model.setPublicIpAddress(device.getPublicIpAddress());
        model.setLocalIpAddress(device.getLocalIpAddress());
        model.setVersionMajor(device.getVersionMajor());
        model.setVersionMinor(device.getVersionMinor());
        model.setBuildNo(device.getBuildNo());
        model.setDeviceType(device.getDeviceType());
        model.setLastAlive(device.getLastAlive());
        model.setConnectedDate(device.getConnectedDate());
        model.setEncryptedControlConnection(device.isEncryptedControlConnection());
        model.setGateway(device.isGateway());
        model.setEmbedded(device.isEmbedded());
        model.setNas(device.isNAS());
        model.setStargate(device.isStargate());
        return model;
    }

    @GET
    @Path(value="/device/{deviceId}/forceUpgrade")
    public ForceUpgradeResponse forceUpgrade(@PathParam(value="deviceId") String deviceId) {
        log.debug((Object)("start forceUpgrade(deviceId=" + deviceId + ")"));
        if (Utils.isBlank(deviceId)) {
            return new ForceUpgradeResponse(ForceUpgradeResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (this.gatewayDeviceConnection.findById(deviceId) == null) {
            return new ForceUpgradeResponse(ForceUpgradeResponse.ErrorCode.DEVICE_NOT_CONNECTED);
        }
        this.gatewayDeviceConnection.forceUpgrade(deviceId);
        return new ForceUpgradeResponse(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/device/{deviceId}/executeCommand")
    public ExecuteCommandResponse executeCmd(@PathParam(value="deviceId") String deviceId, @QueryParam(value="command") String command, @QueryParam(value="timeout") Long timeout) {
        log.debug((Object)("start executeCmd(deviceId=" + deviceId + ", command=" + command + ", timeout=" + timeout + ")"));
        if (Utils.isBlank(deviceId)) {
            return new ExecuteCommandResponse(ExecuteCommandResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (Utils.isBlank(command)) {
            return new ExecuteCommandResponse(ExecuteCommandResponse.ErrorCode.NO_COMMAND);
        }
        ExecCmdService service = this.serviceFactory.getExecCmdService(timeout);
        CmdResult result = service.executeCommand(deviceId, command);
        if (result == null) {
            return new ExecuteCommandResponse(Response.Status.FAILURE);
        }
        return new ExecuteCommandResponse(Response.Status.SUCCESS, this.toCommandResult(result));
    }

    private CommandResult toCommandResult(CmdResult cmdResult) {
        if (cmdResult == null) {
            return null;
        }
        return new CommandResult(cmdResult.getOutput(), cmdResult.getStatusCode());
    }

    @GET
    @Path(value="/device/{deviceId}/candidates")
    public SearchCandidatesResponse searchCandidates(@PathParam(value="deviceId") String deviceId, @QueryParam(value="stunAddr") String stunAddr, @QueryParam(value="stunPort") Integer stunPort, @QueryParam(value="turnAddr") String turnAddr, @QueryParam(value="turnPort") Integer turnPort, @QueryParam(value="turnUser") String turnUser, @QueryParam(value="turnPass") String turnPass, @QueryParam(value="candidates") String candidates) {
        log.debug((Object)("start searchCandidates(deviceId=" + deviceId + ", stunAddr=" + stunAddr + ", stunPort=" + stunPort + ", turnAddr=" + turnAddr + ", turnPort=" + turnPort + ", turnUser=" + turnUser + ", turnPass=" + turnPass + ", candidates=" + candidates + ")"));
        SearchCandidatesResponse.ErrorCode errorCode = this.validateSearchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        if (errorCode != null) {
            return new SearchCandidatesResponse(errorCode);
        }
        IceTransportService service = this.serviceFactory.getIceTransportService();
        Candidates foundCandidates = service.execute(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        if (foundCandidates == null) {
            return new SearchCandidatesResponse(SearchCandidatesResponse.ErrorCode.ERROR);
        }
        return new SearchCandidatesResponse(foundCandidates.getCandidates(), foundCandidates.getPortRangeStart(), foundCandidates.getPortRangeEnd());
    }

    private SearchCandidatesResponse.ErrorCode validateSearchCandidates(String deviceId, String stunAddr, Integer stunPort, String turnAddr, Integer turnPort, String turnUser, String turnPass, String candidates) {
        if (Utils.isBlank(deviceId)) {
            return SearchCandidatesResponse.ErrorCode.NO_DEVICE_ID;
        }
        if (Utils.isBlank(stunAddr)) {
            return SearchCandidatesResponse.ErrorCode.NO_STUN_ADDR;
        }
        if (stunPort == null) {
            return SearchCandidatesResponse.ErrorCode.NO_STUN_PORT;
        }
        if (turnAddr == null) {
            return SearchCandidatesResponse.ErrorCode.NO_TURN_ADDR;
        }
        if (turnPort == null) {
            return SearchCandidatesResponse.ErrorCode.NO_TURN_PORT;
        }
        if (turnUser == null) {
            return SearchCandidatesResponse.ErrorCode.NO_TURN_USER;
        }
        if (turnPass == null) {
            return SearchCandidatesResponse.ErrorCode.NO_TURN_PASS;
        }
        if (Utils.isBlank(candidates)) {
            return SearchCandidatesResponse.ErrorCode.NO_CONDIDATES;
        }
        return null;
    }

    @POST
    @Path(value="/device/{deviceId}/httpclient")
    @Consumes(value={"application/json"})
    public ExecuteHttpCommandResponse executeHttpCommand(@PathParam(value="deviceId") String deviceId, HttpCommand command) {
        log.debug((Object)("start executeHttpCommand(deviceId=" + deviceId + ", command=" + command + ")"));
        ExecuteHttpCommandResponse.ErrorCode errorCode = this.validateHttpCommand(deviceId, command);
        if (errorCode != null) {
            return new ExecuteHttpCommandResponse(errorCode);
        }
        URL url = null;
        try {
            url = new URL(command.getUrl());
        }
        catch (MalformedURLException e) {
            return new ExecuteHttpCommandResponse(ExecuteHttpCommandResponse.ErrorCode.MALFORMED_URL);
        }
        HTTPClientService service = this.getHttpClientService(command);
        HTTPClientServiceResult result = null;
        switch (command.getMethod()) {
            case GET: {
                result = service.get(deviceId, url);
                break;
            }
            case POST: {
                byte[] body = this.getHttpCommandBody(command);
                result = service.post(deviceId, url, command.getHeaders(), body);
            }
        }
        if (result == null) {
            log.warn((Object)("No result for http command: " + command));
            return new ExecuteHttpCommandResponse(ExecuteHttpCommandResponse.ErrorCode.ERROR);
        }
        return new ExecuteHttpCommandResponse(result);
    }

    private ExecuteHttpCommandResponse.ErrorCode validateHttpCommand(String deviceId, HttpCommand cmd) {
        if (Utils.isBlank(deviceId)) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_DEVICE_ID;
        }
        if (cmd == null) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_COMMAND;
        }
        if (cmd.getMethod() == null) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_METHOD;
        }
        if (cmd.getConnectionType() == null) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_CONNECTION_TYPE;
        }
        if (Utils.isBlank(cmd.getUrl())) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_URL;
        }
        if (cmd.getMethod() == HttpCommand.SendMethod.POST && Utils.isBlank(cmd.getBody())) {
            return ExecuteHttpCommandResponse.ErrorCode.NO_BODY;
        }
        return null;
    }

    private HTTPClientService getHttpClientService(HttpCommand command) {
        HTTPClientService service = null;
        service = command.getConnectionType() == HttpCommand.ConnectionType.TCP_CLIENT ? new HTTPClientService(this.tcpClient) : new HTTPClientService(this.tcpProxy);
        if (command.getTimeout() != null) {
            service.setTimeout(command.getTimeout().intValue());
        }
        return service;
    }

    byte[] getHttpCommandBody(HttpCommand command) {
        return command.getBody() == null ? null : Base64.decodeBase64((String)command.getBody());
    }

    @GET
    @Path(value="/device/{deviceId}/tcpProxy")
    public CreateTcpProxyResponse createTcpProxy(@PathParam(value="deviceId") String deviceId, @QueryParam(value="localPort") Integer localPort, @QueryParam(value="dstAddress") String dstAddress, @QueryParam(value="dstPort") Integer dstPort) {
        log.debug((Object)("start createTcpProxy(deviceId=" + deviceId + ", localPort=" + localPort + ", dstAddress=" + dstAddress + ", dstPort=" + dstPort + ")"));
        if (Utils.isBlank(deviceId)) {
            return new CreateTcpProxyResponse(CreateTcpProxyResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (localPort == null) {
            return new CreateTcpProxyResponse(CreateTcpProxyResponse.ErrorCode.NO_LOCAL_PORT);
        }
        if (Utils.isBlank(dstAddress)) {
            return new CreateTcpProxyResponse(CreateTcpProxyResponse.ErrorCode.NO_DST_ADDRESS);
        }
        if (dstPort == null) {
            return new CreateTcpProxyResponse(CreateTcpProxyResponse.ErrorCode.NO_DST_PORT);
        }
        TCPProxyApp proxyApp = new TCPProxyApp(localPort, deviceId, dstAddress, dstPort, this.tcpProxy, null);
        proxyApp.start();
        return new CreateTcpProxyResponse(proxyApp.getLocalPort());
    }

    @POST
    @Path(value="/device/{deviceId}/log")
    public ConfigureLoggerResponse configureLogger(@PathParam(value="deviceId") String deviceId, String data) {
        log.debug((Object)("start configureLogger(deviceId=" + deviceId + ", data=" + data + ")"));
        if (Utils.isBlank(deviceId)) {
            return new ConfigureLoggerResponse(ConfigureLoggerResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (Utils.isBlank(data)) {
            return new ConfigureLoggerResponse(ConfigureLoggerResponse.ErrorCode.NO_LOGGER_CONFIGURATION);
        }
        LoggerConfiguratorService service = this.serviceFactory.getLoggerConfiguratorService();
        return new ConfigureLoggerResponse(service.configureLogs(deviceId, data));
    }

    @GET
    @Path(value="/device/{deviceId}/discoverCameraIp")
    public DiscoverCameraIpAddressResponse discoverCameraIpAddress(@PathParam(value="deviceId") String deviceId, @QueryParam(value="mac") String mac) {
        log.debug((Object)("start discoverCameraIpAddress(deviceId=" + deviceId + ", mac=" + mac + ")"));
        if (Utils.isBlank(deviceId)) {
            return new DiscoverCameraIpAddressResponse(DiscoverCameraIpAddressResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (Utils.isBlank(mac)) {
            return new DiscoverCameraIpAddressResponse(DiscoverCameraIpAddressResponse.ErrorCode.NO_MAC);
        }
        VivotekCameraIpAddressDiscoveryService service = this.serviceFactory.getVivotekCameraIpAddressDiscoveryService();
        return new DiscoverCameraIpAddressResponse(service.getCameraIpAddress(deviceId, mac));
    }

    @GET
    @Path(value="/device/{deviceId}/discover")
    public DiscoverDeviceResponse discoverDevice(@PathParam(value="deviceId") String deviceId, @QueryParam(value="make") String make) {
        log.debug((Object)("start discoverDevice(deviceId=" + deviceId + ", make=" + make + ")"));
        if (Utils.isBlank(deviceId)) {
            return new DiscoverDeviceResponse(DiscoverDeviceResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (Utils.isBlank(make)) {
            return new DiscoverDeviceResponse(DiscoverDeviceResponse.ErrorCode.NO_MAKE);
        }
        Make cameraMake = Make.parse(make);
        if (cameraMake == null) {
            return new DiscoverDeviceResponse(DiscoverDeviceResponse.ErrorCode.INVALID_MAKE);
        }
        CameraDiscoveryService service = this.serviceFactory.getCameraDiscoveryService(cameraMake);
        if (service == null) {
            log.debug((Object)("No camera discovery service found for make=" + make + "."));
            return new DiscoverDeviceResponse(DiscoverDeviceResponse.ErrorCode.ERROR);
        }
        return new DiscoverDeviceResponse(service.discover(deviceId));
    }

    @GET
    @Path(value="/device/{deviceId}/setUpForwarding")
    public SetUpUpnpForwardingResponse setUpUpnpForwarding(@PathParam(value="deviceId") String deviceId, @QueryParam(value="upnpPort") Integer upnpPort) {
        log.debug((Object)("start setUpUpnpForwarding(deviceId=" + deviceId + ", upnpPort=" + upnpPort + ")"));
        if (Utils.isBlank(deviceId)) {
            return new SetUpUpnpForwardingResponse(SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID);
        }
        try {
            SetUpUpnpForwardingResult result = this.serviceFactory.getUpnpPortForwardingServiceImpl().setUpForwarding(deviceId, upnpPort);
            return new SetUpUpnpForwardingResponse(result);
        }
        catch (SetUpForwardingException ex) {
            return new SetUpUpnpForwardingResponse(ex.getErrorCode());
        }
    }

    @GET
    @Path(value="/device/{deviceId}/registered")
    public String isDeviceRegistered(@PathParam(value="deviceId") String deviceId) {
        return "" + this.sessionDao.isDeviceRegisterd(deviceId);
    }

    @PUT
    @Path(value="/device/{deviceId}/registered")
    public SetRegisteredResponse setRegistered(@PathParam(value="deviceId") String deviceId, @QueryParam(value="registered") Boolean registered) {
        log.debug((Object)("start setRegistered(deviceId=" + deviceId + ", registered=" + registered + ")"));
        if (Utils.isBlank(deviceId)) {
            return new SetRegisteredResponse(SetRegisteredResponse.ErrorCode.NO_DEVICE_ID);
        }
        if (registered == null) {
            return new SetRegisteredResponse(SetRegisteredResponse.ErrorCode.NO_REGISTERED_STATUS);
        }
        this.sessionDao.registered(deviceId, registered);
        return new SetRegisteredResponse();
    }

    @PUT
    @Path(value="/registered")
    public Response batchRegistered(String data) {
        log.debug((Object)("start batchRegistered(data=" + data + ")"));
        Gson gson = new Gson();
        RegisteredBatch batch = (RegisteredBatch)gson.fromJson(data, RegisteredBatch.class);
        for (Map.Entry<String, Boolean> entry : batch.getBatch().entrySet()) {
            this.sessionDao.registered(entry.getKey(), entry.getValue());
        }
        return new Response(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/sessions")
    public String getSessions() {
        log.debug((Object)"start getSessions()");
        Collection<SessionEntity> sessions = this.sessionDao.getSessions();
        log.debug((Object)(">>> sessions count: " + sessions.size()));
        for (SessionEntity session : sessions) {
            log.debug((Object)(">>> " + session.dump()));
        }
        return "ok";
    }

    @POST
    @Path(value="/dns")
    public AddDomainNameResponse addDomainName(DomainName data) {
        log.debug((Object)("start addDomainName(data=" + data + " )"));
        if (Utils.isBlank(data.getName())) {
            return new AddDomainNameResponse(AddDomainNameResponse.ErrorCode.NO_NAME);
        }
        if (Utils.isBlank(data.getMac())) {
            return new AddDomainNameResponse(AddDomainNameResponse.ErrorCode.NO_MAC);
        }
        if (data.getType() == null) {
            return new AddDomainNameResponse(AddDomainNameResponse.ErrorCode.NO_TYPE);
        }
        this.domainNameService.add(data.getName(), data.getMac(), data.getType());
        return new AddDomainNameResponse(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/dns/{name}")
    public GetDomainNameResponse getDomainName(@PathParam(value="name") String name) {
        log.debug((Object)("start getDomainName(name=" + name + ")"));
        if (Utils.isBlank(name)) {
            return new GetDomainNameResponse(GetDomainNameResponse.ErrorCode.NO_NAME);
        }
        DomainNameValue value = this.domainNameService.get(name);
        return new GetDomainNameResponse(Response.Status.SUCCESS, value == null ? null : new DomainName(name, value.getMac(), value.getType()));
    }

    @DELETE
    @Path(value="/dns/{name}")
    public RemoveDomainNameResponse removeDomainName(@PathParam(value="name") String name) {
        log.debug((Object)("start removeDomainName(name=" + name + ")"));
        if (Utils.isBlank(name)) {
            return new RemoveDomainNameResponse(RemoveDomainNameResponse.ErrorCode.NO_NAME);
        }
        this.domainNameService.remove(name);
        return new RemoveDomainNameResponse(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/version")
    public GetVersionResponse getVersion() {
        return new GetVersionResponse(GDServer.VERSION.toString());
    }

    @GET
    @Path(value="/worker/messages/count")
    public String getWorkerMessagesCount() {
        return "" + this.appServerConnector.getMessagesCount();
    }

    @GET
    @Path(value="/sys/heapstats")
    public String getHeapStats() {
        Runtime runtime = Runtime.getRuntime();
        int mb = 0x100000;
        return String.valueOf(runtime.maxMemory() / (long)mb) + "/" + runtime.totalMemory() / (long)mb + "/" + runtime.freeMemory() / (long)mb;
    }

    @Autowired
    @Required
    public void setConnectionCallbacks(ConnectionCallbacks connectinoCollbacks) {
        this.connectionCollbacks = connectinoCollbacks;
    }

    @Autowired
    @Required
    @Value(value="${GDConnection.restUrl}")
    public void setServerUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    @GET
    @Path(value="/test/device/{deviceId}/connect")
    public String testConnect(@PathParam(value="deviceId") String deviceId) {
        this.gatewayDeviceConnection.addVerifiedDevice(deviceId, "1.2.3.4", "192.168.1.100");
        this.connectionCollbacks.connected(deviceId, "1.2.3.4", "192.168.1.100", this.restUrl);
        return "OK";
    }

    @GET
    @Path(value="/test/device/{deviceId}/disconnect")
    public String testDisconnect(@PathParam(value="deviceId") String deviceId) {
        this.gatewayDeviceConnection.removeVerifiedDevice(deviceId);
        this.connectionCollbacks.disconnected(deviceId, "1.2.3.4", "MANUAL", this.restUrl);
        return "OK";
    }
}

