/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.db.dao;

import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.util.SharedCache;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Repository;

@Repository
public class SharedSessionDao
implements SessionDao {
    private static Logger log = Logger.getLogger(SharedSessionDao.class);
    private SharedCache sharedCache;
    private ConcurrentMap<String, SessionEntity> sessions;

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @PostConstruct
    public void initialize() {
        this.sessions = this.sharedCache.getMap("sessions");
    }

    @Override
    public void store(String mac, SessionEntity session) {
        log.trace((Object)("start store(mac=" + mac + "session=" + session + ")"));
        this.sessions.put(mac, session);
    }

    @Override
    public SessionEntity get(String mac) {
        SessionEntity session = (SessionEntity)this.sessions.get(mac);
        log.trace((Object)("get(mac=" + mac + ") -> " + session));
        return session;
    }

    @Override
    public void disconnected(String mac, String serverUrl) {
        log.debug((Object)("start disconnected(" + mac + ", " + serverUrl + ")"));
        SessionEntity session = (SessionEntity)this.sessions.get(mac);
        if (session != null && serverUrl != null && serverUrl.equals(session.getServerUrl())) {
            log.debug((Object)"setting disconnected to true");
            session.setConnected(false);
            this.sessions.put(mac, session);
        }
    }

    @Override
    public void disconnected(String serverUrl) {
    }

    @Override
    public void registered(String mac, boolean registered) {
        log.trace((Object)("start registered(mac=" + mac + ", registered=" + registered + ")"));
        SessionEntity session = (SessionEntity)this.sessions.get(mac);
        if (session == null) {
            log.warn((Object)("Trying to set registered=" + registered + " for non-existent device with mac=" + mac));
            return;
        }
        session.setRegistered(registered);
        this.sessions.put(mac, session);
    }

    @Override
    public boolean isDeviceRegisterd(String mac) {
        SessionEntity session = (SessionEntity)this.sessions.get(mac);
        return session != null && session.isRegistered();
    }

    @Override
    public void remove(String mac) {
        log.trace((Object)("start remove(mac=" + mac + ")"));
        this.sessions.remove(mac);
    }

    @Override
    public Collection<SessionEntity> getSessions() {
        log.trace((Object)"start getSessions()");
        return this.sessions.values();
    }
}

