/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.db.dao;

import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.dao.SharedSessionDao;
import com.vestiacom.gdserver.db.dao.SqlSessionDao;
import com.vestiacom.gdserver.util.ExceptionsTrigger;
import com.vestiacom.gdserver.util.Utils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DaoFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private PersistanceEngine persistanceEngine;

    @Value(value="${dao.persistanceEngine}")
    public void setPersistanceEngine(String persistanceEngine) {
        this.persistanceEngine = PersistanceEngine.parse(persistanceEngine);
        ExceptionsTrigger.throwIfNull((Object)this.persistanceEngine, new NullPointerException("persistanceEngine"));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SessionDao getSessionDao() {
        switch (this.persistanceEngine) {
            case SQL: {
                return (SqlSessionDao)this.applicationContext.getBean("sqlSessionDao");
            }
            case HAZELCAST: {
                return (SharedSessionDao)this.applicationContext.getBean("sharedSessionDao");
            }
        }
        throw new IllegalArgumentException("Unsupported persistance engine: " + (Object)((Object)this.persistanceEngine));
    }

    private static enum PersistanceEngine {
        SQL,
        HAZELCAST;


        public static PersistanceEngine parse(String engine) {
            if (Utils.isBlank(engine)) {
                return null;
            }
            try {
                return PersistanceEngine.valueOf(engine.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }
}

