/************************  device_def.h  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description:      ATMega device configuration
 *
 * Author:      Valeriy Vyshnyak
 *
 * Last Changed By:  $Author: vvi $
 * Revision:         $Revision: 0000 $
 * Last Changed:     $Date: 2009-11-11 $
 *
 ****************************************************************************/

/* definitions generated by preprocessor, copy into defines.h */
#ifndef	_DEVICE_DEF_H_
/* baud rate register value calculation */
#define	F_CPU 7372800 // MHz

#define _B4096

#define	PAGESIZE	SPM_PAGESIZE

#ifdef _B512
  #define APP_PAGES ((2*65536UL / SPM_PAGESIZE)- (2*512 / SPM_PAGESIZE ))
  #define APP_END APP_PAGES * SPM_PAGESIZE
#endif
#ifdef _B1024
  #define APP_PAGES ((2*65536UL / SPM_PAGESIZE)- (2*1024 / SPM_PAGESIZE ))
  #define APP_END APP_PAGES * SPM_PAGESIZE
#endif
#ifdef _B2048
  #define APP_PAGES ((2*65536UL / SPM_PAGESIZE)- (2*2048 / SPM_PAGESIZE ))
  #define APP_END APP_PAGES * SPM_PAGESIZE
#endif
#ifdef _B4096
  #define APP_PAGES ((2*65536UL / SPM_PAGESIZE)- (2*4096 / SPM_PAGESIZE ))
  #define APP_END APP_PAGES * SPM_PAGESIZE
#endif

/* indicate that preprocessor result is included */
#define	_DEVICE_DEF_H_
#endif
