/**********************************  io.h  **********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: See below.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-08-11   OZA     Integrated with Z-Wave environment.
 * 
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.1 $
 * Last Changed:     $Date: 2007/08/30 11:39:20 $
 * Ported to iccAVR
 ****************************************************************************/

#ifndef IO_H
#define IO_H

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
#define  F_CPU  7372000L

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
BOOL bSerialInit( void );
BYTE bySerialCheck( void );
BYTE bySerialGetByte( void );
void vSerialPutByte( BYTE byTheByte );
//void vSerialPutBuffer(BYTE *buffer, BYTE length);
void mPORTInit();
unsigned char IOOpen(u32 bitrate);
void IOClose(void);
void IOProcessEvents(void);
UCHAR puts(UCHAR *pStrData);
UCHAR putrs(RUCHAR *pStrData);
char getc(void);
void vSerial0PutByte(BYTE byTheByte);
void vSerial0PutNum( BYTE byTheByte );
#endif // IO_H

