/*****************************  UART_BUF_IO.H  ******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description:       Buffered transmit/receive of data through the UART
 *
 * Author:            Kim Jakobsen
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 21430 $
 * Last Changed:     $Date: 2011-09-27 22:46:12 +0200 (Tue, 27 Sep 2011) $
 *
 ****************************************************************************/
#ifndef _UART_BUF_IO_H_
#define _UART_BUF_IO_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
extern BOOL txActive;
extern BOOL rxActive;
extern BOOL Timeout;
extern BOOL AckNakNeeded;

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
BYTE SerialCheck(void);
BYTE SerialGetByte(void);
void SerialPutByte(BYTE ch);
void InitSerialIf(void);

#endif /* _UART_BUF_IO_H_ */
