$NOMOD51
;*****************************  UART_buf_io.a51  *****************************
;*           #######
;*           ##  ##
;*           #  ##    ####   #####    #####  ##  ##   #####
;*             ##    ##  ##  ##  ##  ##      ##  ##  ##
;*            ##  #  ######  ##  ##   ####   ##  ##   ####
;*           ##  ##  ##      ##  ##      ##   #####      ##
;*          #######   ####   ##  ##  #####       ##  #####
;*                                           #####
;*          Z-Wave, the wireless language.
;*
;*              Copyright (c) 2001
;*              Zensys A/S
;*              Denmark
;*
;*              All Rights Reserved
;*
;*    This source file is subject to the terms and conditions of the
;*    Zensys Software License Agreement which restricts the manner
;*    in which it may be used.
;*
;*---------------------------------------------------------------------------
;*
;* Description: Serial port driver for serialAPI
;*
;* Author:   Erik Friis Harck
;*
;* Last Changed By:  $Author: imj $
;* Revision:         $Revision: 2 $
;* Last Changed:     $Date: 2001-07-05 12:05:49 +0200 (Thu, 05 Jul 2001) $
;*
;****************************************************************************

;****************************************************************************
;*                               INCLUDE FILES
;****************************************************************************
#ifdef ZW030x
#include <ZW030x.h>
#else
#include <ZW020x.h>
#endif

;****************************************************************************
;*                      PRIVATE TYPES and DEFINITIONS                       *
;****************************************************************************
NAME	UART_BUF_IO

UARTCON	DATA	0D8H
UARTRX	DATA	0BFH
UARTTX	DATA	0CBH

?PR?UART0_RX_TX_interrupt?UART_BUF_IO    SEGMENT CODE
?PR?SerialCheck?UART_BUF_IO              SEGMENT CODE
?PR?SerialGetByte?UART_BUF_IO            SEGMENT CODE
?PR?_SerialPutByte?UART_BUF_IO           SEGMENT CODE
?XD?_SerialPutByte?UART_BUF_IO           SEGMENT XDATA OVERLAYABLE
?PR?InitSerialIf?UART_BUF_IO             SEGMENT CODE
?C_INITSEG           SEGMENT CODE
?BI?UART_BUF_IO      SEGMENT BIT
?DT?UART_BUF_IO      SEGMENT DATA
?XD?UART_BUF_IO      SEGMENT XDATA
?PD?UART_BUF_IO      SEGMENT XDATA INPAGE
	EXTRN	CODE (_UART_Write)
;;	EXTRN	CODE (UART_Read)
	EXTRN	CODE (ZW_Poll)
;;	EXTRN	CODE (UART_SendStatus)
;;	EXTRN	CODE (UART_RecStatus)
;;	EXTRN	CODE (UART_ClearRx)
;;	EXTRN	CODE (UART_ClearTx)

	EXTRN	BIT (txBusy)

;****************************************************************************/
;*                              EXPORTED DATA                               */
;****************************************************************************/

	PUBLIC	txCount
	PUBLIC	rxCount
	PUBLIC	AckNakNeeded
	PUBLIC	txQueue
	PUBLIC	rxQueue
	PUBLIC	Timeout
	PUBLIC	txOutPtr
	PUBLIC	rxOutPtr
	PUBLIC	txInPtr
	PUBLIC	rxInPtr
	PUBLIC	txActive
	PUBLIC	rxActive
	PUBLIC	InitSerialIf
	PUBLIC	_SerialPutByte
	PUBLIC	SerialGetByte
	PUBLIC	SerialCheck
	PUBLIC	UART0_RX_TX_interrupt

	RSEG  ?XD?_SerialPutByte?UART_BUF_IO
?_SerialPutByte?BYTE:
        val?341:   DS   1

	RSEG  ?BI?UART_BUF_IO
       rxActive:   DBIT   1
       txActive:   DBIT   1
        Timeout:   DBIT   1
   AckNakNeeded:   DBIT   1

	RSEG  ?DT?UART_BUF_IO
; volatile IBYTE rxInPtr;
        rxInPtr:   DS   1
; volatile IBYTE txInPtr;
        txInPtr:   DS   1
; volatile IBYTE rxOutPtr;
       rxOutPtr:   DS   1
; volatile IBYTE txOutPtr;
       txOutPtr:   DS   1
; volatile IBYTE rxCount;
        rxCount:   DS   1
; volatile IBYTE txCount;
        txCount:   DS   1

; volatile BYTE rxQueue[UART_RX_BUFSIZE];
	RSEG  ?XD?UART_BUF_IO
        rxQueue:   DS   24

; volatile PBYTE txQueue[UART_TX_BUFSIZE];
	RSEG  ?PD?UART_BUF_IO
        txQueue:   DS   24

	RSEG  ?C_INITSEG
; BOOL txActive = FALSE;
	DB	0C1H, txActive + 000H	; bit-init
; BOOL rxActive = FALSE;
	DB	0C1H, rxActive + 000H	; bit-init
; BOOL Timeout = FALSE;
	DB	0C1H, Timeout + 000H	; bit-init
; BOOL AckNakNeeded = FALSE;
	DB	0C1H, AckNakNeeded + 000H	; bit-init

;
; /****************************************************************************/
; /*                            PRIVATE FUNCTIONS                             */
; /****************************************************************************/
;
;
;****************************************************************************/
;*                           EXPORTED FUNCTIONS                             */
;****************************************************************************/

CSEG	AT	00023H
	LJMP	UART0_RX_TX_interrupt

;*==========================   UART0_RX_TX_interrupt   =======================
;*    Function description
;*
;*    C-prototype:    UART0_RX_TX_interrupt( void ) interrupt INUM_SERIAL
;*
;*    Input: None
;*
;*    Return: None
;*
;*    Destroys: None
;*
;*    Side effects: None
;*---------------------------------------------------------------------------
	RSEG  ?PR?UART0_RX_TX_interrupt?UART_BUF_IO
	USING	0
UART0_RX_TX_interrupt:
	PUSH 	ACC
	PUSH 	DPH
	PUSH 	DPL
	PUSH 	PSW
	MOV  	PSW,#00H
	PUSH 	AR0
	PUSH 	AR7
	USING	0
			; SOURCE LINE # 104
;{
; if (ZW_UART_REC_STATUS) /* Any receiver interrupt? */
	MOV  	A,UARTCON
  JNB  	ACC.0,?C0001
; {
;   ZW_UART_CLEAR_RX;
	  ANL  	UARTCON,#0FDH

;   bReceivedByte = ZW_UART_READ;
	  ; Get the byte
    MOV  	R7,UARTRX

;   if (rxInPtr >= UART_RX_BUFSIZE)
	  MOV  	A,rxInPtr
	  CLR  	C
	  SUBB 	A,#018H
	  JC   	?C0002
;   {
;       rxInPtr = 0;  /* Wrap around */
	      MOV  	rxInPtr,#00H
;   }
?C0002:
;     if (rxCount < UART_RX_BUFSIZE)
	    MOV  	A,rxCount
	    CLR  	C
	    SUBB 	A,#018H
	    JNC  	?C0003
;     {
;       /* Put the received byte in the RX queue */
;       rxQueue[rxInPtr++] = bReceivedByte;    /* Get it */

        MOV   A,rxInPtr
	      INC  	rxInPtr
	      ADD   A,#LOW (rxQueue)
	      MOV  	DPL,A
	      CLR  	A
	      ADDC 	A,#HIGH (rxQueue)
	      MOV  	DPH,A
	      ; Received byte is in R7
	      MOV  	A,R7
	      MOVX 	@DPTR,A
;       rxCount++;
	      INC  	rxCount
	      SJMP 	?C0001
;     }
?C0003:
;     else
;     {
;       /* Received byte dropped */
;       rxCount = UART_RX_BUFSIZE;
	      ;MOV  	rxCount,#018H
;     }
;   }
?C0001:
; if (!ZW_UART_SEND_STATUS) /* Any transmitter interrupt? */
	MOV  	A,UARTCON
	JNB  	ACC.1,UART_SendStatus_C0007
	CLR  	txBusy
UART_SendStatus_C0007:
	MOV  	C,txBusy
  JC    ?C0009
; {
;   ZW_UART_CLEAR_TX;
	  ANL  	UARTCON,#0FEH
	  ; Is allready Cleared
	  ;CLR  	txBusy
;   if (txCount > 0)  /* Anything in buffer ? */
	  MOV  	A,txCount
    JZ    ?C0006
;   {
;     if (txOutPtr >= UART_TX_BUFSIZE)
	    MOV  	A,txOutPtr
	    ; Carry is cleared
	    SUBB 	A,#018H
	    JC   	?C0007
;     {
;       txOutPtr = 0;
	      MOV  	txOutPtr,#00H
;     }
?C0007:
;     ZW_UART_WRITE(txQueue[txOutPtr++]); /* Here it goes... */
	    MOV  	A,txOutPtr
	    INC  	txOutPtr
	    ADD  	A,#LOW (txQueue)
	    MOV  	R0,A
	    MOVX 	A,@R0
	    MOV  	UARTTX,A
	    SETB 	txBusy
;     txCount--;
	    DEC  	txCount
;   }
	  SJMP 	?C0009
?C0006:
;   else
;   {
;     txActive = 0; /* Tell the world we're ready for more */
	    CLR  	txActive
;   }
; }
;}
?C0009:
	POP  	AR7
	POP  	AR0
	POP  	PSW
	POP  	DPL
	POP  	DPH
	POP  	ACC
	RETI
; END OF UART0_RX_TX_interrupt


;*==============================   SerialCheck   ============================
;*    Function description
;*
;*    C-prototype:    BYTE                  /*RET  non-zero if data is ready
;*                    SerialCheck(void)     /*IN  Nothing     */
;*
;*    Input:          None
;*
;*    Return:         R7  rxCount   Number of bytes reay in the receive queue
;*
;*    Destroys:       R7
;*
;*    Side effects:   None
;*---------------------------------------------------------------------------
	RSEG  ?PR?SerialCheck?UART_BUF_IO
SerialCheck:
	USING	0
; {
;   return rxCount;
	  MOV  	R7,rxCount
; }
?C0010:
	RET
; END OF SerialCheck

;*=============================   SerialGetByte   ===========================
;*    Function description
;*
;*    C-prototype:    BYTE                    /*RET   The read byte  */
;*                    SerialGetByte(void)     /*IN    Nothing */
;*
;*    Input:          None
;*
;*    Return:         R7  rxByte   The receive byte
;*
;*    Destroys:       A, R7
;*
;*    Side effects:   None
;*---------------------------------------------------------------------------
	RSEG  ?PR?SerialGetByte?UART_BUF_IO
SerialGetByte:
	USING	0
; {
;   BYTE retVal;

;   if (rxOutPtr >= UART_RX_BUFSIZE)
  	MOV  	A,rxOutPtr
	  CLR  	C
	  SUBB 	A,#018H
	  JC   	?C0011
;   {
;     rxOutPtr = 0;
	    CLR  	A
	    MOV  	rxOutPtr,A
;   }
?C0011:
;   retVal = rxQueue[rxOutPtr++];
  	MOV  	A,rxOutPtr
	  INC  	rxOutPtr
	  ADD  	A,#LOW (rxQueue)
	  MOV  	DPL,A
	  CLR  	A
	  ADDC 	A,#HIGH (rxQueue)
	  MOV  	DPH,A
	  MOVX 	A,@DPTR
	  MOV  	R7,A
;---- Variable 'retVal?240' assigned to Register 'R7' ----
;   DSI;  /* Disable "serial" interrupt */
  	CLR  	ES
;   if (rxCount > 0)  // Make sure...
	  MOV  	A,rxCount
	  JZ   	?C0012
;   {
;     rxCount--;
    	DEC  	rxCount
;   }
?C0012:
;   ESI;  /* Enable "serial" interrupt */
  	SETB 	ES
;   return retVal;
; }
?C0013:
	RET
; END OF SerialGetByte

;*=============================   SerialPutByte   ===========================
;*    Function description
;*
;*    C-prototype:    void                     /*RET  Nothing */
;*                    SerialPutByte(BYTE val)  /*IN   Byte value to transmit */
;*
;*    Input:          None
;*
;*    Return:         R7
;*
;*    Destroys:       A, R7
;*
;*    Side effects:   None
;*---------------------------------------------------------------------------
	RSEG  ?PR?_SerialPutByte?UART_BUF_IO
_SerialPutByte:
	USING	0

	MOV  	DPTR,#val?341
	MOV  	A,R7
	MOVX 	@DPTR,A

; {
?C0014:
;   while (txCount >= UART_TX_BUFSIZE)
	  MOV  	A,txCount
	  CLR  	C
	  SUBB 	A,#018H
	  JC   	?C0015
;   {
;     ZW_Poll();
    	LCALL	ZW_Poll
;   }
	  SJMP 	?C0014
?C0015:
;   if (txInPtr >= UART_TX_BUFSIZE)
  	MOV  	A,txInPtr
	  CLR  	C
	  SUBB 	A,#018H
	  JC   	?C0016
;   {
;     txInPtr = 0;
    	CLR  	A
	    MOV  	txInPtr,A
;   }
?C0016:
; /* In ZW020x we cannot assert the UART interrupt by setting the interrupt flag */
; /* we have to find a new way to activate it. */
; /* Byte to send is now in R0 */
    MOV  	DPTR,#val?341
    MOVX 	A,@DPTR
    MOV   R0,A
;   DSI; /* Critical region for Serial functionality */
    CLR  	ES
;   if (!txActive)  /* Are transmitter at it? */
	  JB   	txActive,?C0017
;   {
;     txActive = TRUE;  /* No */
	    SETB 	  txActive
;     ZW_UART_WRITE(val);
      MOV     R7,AR0
	    LCALL 	_UART_Write
	    SJMP    ?C0018
;   }
?C0017:
;   else
;   {
;     txQueue[txInPtr++] = val;
	    MOV  	A,txInPtr
	    INC  	txInPtr
	    ADD  	A,#LOW (txQueue)
      XCH   A,R0
	    MOVX 	@R0,A
;     txCount++;
    	INC  	txCount
;   }
?C0018:
;   ESI;
	  SETB 	ES
; }
?C0019:
	RET
; END OF _SerialPutByte
;
;
;*=============================   InitSerialIf   ===========================
;*    Function description
;*
;*    C-prototype:    void                    /*RET Nothing */
;*                    InitSerialIf(void)
;*
;*    Input:          None
;*
;*    Return:         None
;*
;*    Destroys:       A, R7
;*
;*    Side effects:   None
;*---------------------------------------------------------------------------
	RSEG  ?PR?InitSerialIf?UART_BUF_IO
InitSerialIf:
	USING	0
; {
;   rxInPtr = rxOutPtr = txInPtr = txOutPtr = rxCount = txCount = 0;
	  CLR  	A
	  MOV  	txCount,A
	  MOV  	rxCount,A
	  MOV  	txOutPtr,A
	  MOV  	txInPtr,A
	  MOV  	rxOutPtr,A
	  MOV  	rxInPtr,A
;   ESI;   /* Enable serial interrupts */
  	SETB 	ES
; }

	RET
; END OF InitSerialIf

	END
