/********************************  EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Peter Shorty
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 21409 $
 * Last Changed:     $Date: 2011-09-27 16:41:27 +0200 (Tue, 27 Sep 2011) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */

/* EEPROM LED dimmer node layout */
#define EEOFFSET_LEVEL              0x00
#define EEOFFSET_STATUS             EEOFFSET_LEVEL + 1
#define EEOFFSET_IGNORE_ALL_ON_OFF  EEOFFSET_LEVEL + 2
#define EEOFFSET_PROTECTED          EEOFFSET_LEVEL + 3
#define EEOFFSET_PROTECTED_RF       EEOFFSET_LEVEL + 4
#define EEOFFSET_MAGIC              EEOFFSET_LEVEL + 5  /* MAGIC */

#define EEOFFSET_TRANSPORT_SETTINGS_START EEOFFSET_MAGIC + 1
#define EEOFFSET_TRANSPORT_SETTINGS_SIZE  TRANSPORT_EEPROM_SETTINGS_SIZE

/* Default values */
#define DEFAULT_LEVEL               99    /* Full light level */
#define DEFAULT_STATUS              0
#define DEFAULT_IGNORE_ALL_ON_OFF   0
#define DEFAULT_PROTECTED           0
#define MAGIC_VALUE                 0x42


#endif /* _EEPROM_H_ */
