/*******************************  EEPROM.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Header file for EEPROM access routines
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 21401 $
 * Last Changed:     $Date: 2011-09-27 16:37:40 +0200 (Tue, 27 Sep 2011) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
/*==============================   EEprom_Validate   ========================
**    Function description
**      Verify that the contens of the EEPROM is correct and reset
**      it if it isn't
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void EEprom_Validate();

/*==============================   EEprom_StoreNode   ========================
**    Function description
**      Store a nodeID in EEPROM
**
**    Side effects:
**      Updates the checksum in EEPROM
**--------------------------------------------------------------------------*/
void EEprom_StoreNode(BYTE bNodeID);

/*==============================   EEprom_GetNode   ========================
**    Function description
**      Get a stored nodeID from EEPROM
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE EEprom_GetNode();

#endif /* _EEPROM_H_ */
