using System;
using System.Collections.Generic;
using System.Text;
using OpenSource.UPnP;
using OpenSource.UPnP.AV;

namespace Zensys.ZWave.UPnPBridge.UPnPClasses
{
    /// <summary>
    /// AVTransport:1 Service Template Version 1.01
    /// If the devices ConnectionManager does not implement the optional PrepareForConnection action, special value 0 
    /// may be used for the InstanceID input parameter. In such a case, the device implements a single static AVTransport 
    /// instance, and only 1 stream can be controlled and sent (or received) at any time.
    /// </summary>
    public class ZWaveUPnPMediaRendererDevice: ZWaveUPnPDevice
    {
        public ZWaveUPnPMediaRendererDevice(UPnPDevice uPnPDevice) : base(uPnPDevice) { }
        private byte mNodeID;
        public byte NodeID
        {
            get { return mNodeID; }
            set { mNodeID = value; }
        }

        private string mTitle;
        public string Title
        {
            get { return mTitle; }
            set { mTitle = value; }
        }

        private string mState;
        public string State
        {
            get { return mState; }
            set { mState = value; }
        }

        private string mStatus;
        public string Status
        {
            get { return mStatus; }
            set { mStatus = value; }
        }
        
        private CpRenderingControl mRenderingControl;
        public CpRenderingControl RenderingControl
        {
            get { return mRenderingControl; }
            set { mRenderingControl = value; }
        }
        public CpAVTransport mAVTransport;
        public CpAVTransport AVTransport
        {
            get { return mAVTransport; }
            set { mAVTransport = value; }
        }
        public CpConnectionManager mConnectionManager;
        public CpConnectionManager ConnectionManager
        {
            get { return mConnectionManager; }
            set { mConnectionManager = value; }
        }
    }
}
