using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.UI;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class UPnPDeviceScannerDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPDeviceScannerForm form = (UPnPDeviceScannerForm)view;
            //Form
            form.Load += actions.UPnPDeviceScannerActions.OnFormLoad;
            form.FormClosing += actions.UPnPDeviceScannerActions.OnFormClosing;
            form.ButtonDeviceScannerReScan.Click += actions.UPnPDeviceScannerActions.OnButtonDeviceScannerReScanClick;
        }

        public void Drop(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPDeviceScannerForm form = (UPnPDeviceScannerForm)view;
            //Form
            form.Load -= actions.UPnPDeviceScannerActions.OnFormLoad;
            form.FormClosing -= actions.UPnPDeviceScannerActions.OnFormClosing;
            form.ButtonDeviceScannerReScan.Click -= actions.UPnPDeviceScannerActions.OnButtonDeviceScannerReScanClick;
        }
        #endregion
    }
}
