using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.UI;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.Models;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class AssociationsFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            AssociationsForm form = (AssociationsForm)view;

            //Form
            form.Load += new EventHandler(actions.AssociationsFormActions.OnFormLoad);
            form.FormClosing += new FormClosingEventHandler(actions.AssociationsFormActions.OnFormClosing);
            form.vcCreateToolStripButton.Click += new EventHandler(actions.AssociationsFormActions.OnCreateToolStripButtonClick);
            form.vcRemoveToolStripButton.Click += new EventHandler(actions.AssociationsFormActions.OnRemoveToolStripButtonClick);
            form.associationGridViewControl.groupTreeView.SelectedChanged += actions.AssociationsFormActions.groupTreeView_AfterSelect;
            form.associationGridViewControl.nodesGridView.KeyUp += new KeyEventHandler(actions.AssociationsFormActions.nodesGridView_KeyUp);
            form.associationGridViewControl.nodesGridView.CellContentClick += new DataGridViewCellEventHandler(actions.AssociationsFormActions.nodesGridView_CellContentClick);
            //DocumentModel
            documentModel.DocumentModelStateChanged += actions.AssociationsFormActions.OnDocumentModelStateChanged;
            //documentModel.AssociativeDevicesCurrencyManager.PositionChanged += actions.AssociationsFormActions.AssociativeDevicesCurrencyManager_PositionChanged;

        }



        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            AssociationsForm form = (AssociationsForm)view;

            //Form
            form.Load -= new EventHandler(actions.AssociationsFormActions.OnFormLoad);
            form.FormClosing -= new FormClosingEventHandler(actions.AssociationsFormActions.OnFormClosing);
            form.vcCreateToolStripButton.Click -= new EventHandler(actions.AssociationsFormActions.OnCreateToolStripButtonClick);
            form.vcRemoveToolStripButton.Click -= new EventHandler(actions.AssociationsFormActions.OnRemoveToolStripButtonClick);
            form.associationGridViewControl.groupTreeView.SelectedChanged -= actions.AssociationsFormActions.groupTreeView_AfterSelect;
            form.associationGridViewControl.nodesGridView.KeyUp -= new KeyEventHandler(actions.AssociationsFormActions.nodesGridView_KeyUp);
            form.associationGridViewControl.nodesGridView.CellContentClick -= new DataGridViewCellEventHandler(actions.AssociationsFormActions.nodesGridView_CellContentClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.AssociationsFormActions.OnDocumentModelStateChanged);
            //documentModel.AssociativeDevicesCurrencyManager.PositionChanged -= actions.AssociationsFormActions.AssociativeDevicesCurrencyManager_PositionChanged;
        }


        #endregion
    }
}
