using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;
using Zensys.ZWave.UPnPBridge.Interfaces;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Classes
{
    public class DockableView : DockContent, IView
    {
        #region IView Members
        public Form ViewContainer
        {
            get { return this; }
        }
        public DockStyle mDockStyle = DockStyle.None;
        public DockStyle DockStyle
        {
            get
            {
                return mDockStyle;
            }
            set
            {
                mDockStyle = value;
            }
        }
        #endregion

        protected override void OnLayout(LayoutEventArgs levent)
        {
            base.OnLayout(levent);
            if (levent.AffectedControl is DockableView)
            {
                switch (this.DockState)
                {
                    case (DockState.DockLeft): { this.DockStyle = DockStyle.Left; } break;
                }
            }
        }
    }
}
