using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using System.Windows.Forms;
using System.Threading;
using OpenSource.UPnP;
using Zensys.Framework.UI.Controls;
using Zensys.Framework;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class UPnPBinaryLightCPActions : BaseAction
    {
        private UPnPSmartControlPoint scpBinary;
        private UPnPSmartControlPoint scpDimmable;
        public UPnPBinaryLightCPActions(ControllerManager controller) : base(controller) { }

        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.ItemColumns.Clear();
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.ItemColumns.Add(new ItemColumn("FriendlyName", new string[] { "FriendlyName" }, OnGetTextFriendlyName, null));
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.ItemColumns.Add(new ItemColumn("StandardDeviceType", new string[] { "StandardDeviceType" }, OnGetTextStandardDeviceType, null));
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.ItemColumns.Add(new ItemColumn("Version", new string[] { "Version" }, OnGetTextVersion, null));
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.ItemColumns.Add(new ItemColumn("PresentationURL", new string[] { "PresentationURL" }, OnGetTextPresentationURL, null));

            scpBinary = new UPnPSmartControlPoint(OnAddSink, "urn:schemas-upnp-org:device:BinaryLight:1");
            scpDimmable = new UPnPSmartControlPoint(OnAddSink, "urn:schemas-upnp-org:device:DimmableLight:1");
            scpBinary.OnRemovedDevice += OnRemoveSink;
            scpDimmable.OnRemovedDevice += OnRemoveSink;              
            ControllerManager.UPnPBinaryLightCPForm.ListViewUPnPBinaryLightDevices.DataSource = ControllerManager.DocumentModel.UpnpBinaryLightDevices;
            ControllerManager.DocumentModel.UpnpBinaryLightDevicesCurrencyManager.CurrentChanged += new EventHandler(UpnpBinaryLightDevicesCurrencyManagerCurrentChanged);
            OnDocumentModelStateChanged();
        }

        private string OnGetTextFriendlyName(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }

        private string OnGetTextStandardDeviceType(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }

        private string OnGetTextVersion(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }

        private string OnGetTextPresentationURL(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        
        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            scpBinary.OnRemovedDevice -= OnRemoveSink;
            scpDimmable.OnRemovedDevice -= OnRemoveSink;
            ControllerManager.DocumentModel.UpnpBinaryLightDevicesCurrencyManager.CurrentChanged -= new EventHandler(UpnpBinaryLightDevicesCurrencyManagerCurrentChanged);
            ControllerManager.MainForm.UPnPBinaryLightCPToolStripMenuItem.Checked = false;
            ControllerManager.UPnPBinaryLightCPForm.Hide();
            e.Cancel = true;
        }

        private void UpnpBinaryLightDevicesCurrencyManagerCurrentChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private void OnDocumentModelStateChanged()
        {

        }
        bool currentStatus=false;
        public void OnButtonToggleClick(object sender, EventArgs e)
        {
            try
            {
                currentStatus = !currentStatus;
                ControllerManager.DocumentModel.CurrentUpnpBinaryLightDevice.SetTarget(currentStatus);
            }
            catch (Exception ex)
            {
                Tools._writeDebugDiagnosticExceptionMessage("ZensysLightToggle: Exception - SwitchPower " + ex.Message);
            }
        }

        public void OnButtonScanClick(object sender, EventArgs e)
        {
            scpBinary.Rescan();
            scpDimmable.Rescan();
        }

        private void OnAddSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ZWaveUPnPBinaryLightDevice device = new ZWaveUPnPBinaryLightDevice(d);
            ControllerManager.DocumentModel.UpnpBinaryLightDevices.Add(device);
        }

        private void OnRemoveSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ZWaveUPnPBinaryLightDevice forRemove = null;
            foreach (ZWaveUPnPBinaryLightDevice var in ControllerManager.DocumentModel.UpnpBinaryLightDevices)
            {
                if (var.UPnPDevice.UniqueDeviceName == d.UniqueDeviceName)
                {
                    forRemove = var;
                    break;
                }
            }
            
            if (forRemove != null)
            {
                ControllerManager.DocumentModel.UpnpBinaryLightDevices.Remove(forRemove);
            }
            ControllerManager.DocumentModel.UpnpBinaryLightDevices.ResetBindings();
        }       
    }
}
