using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.Models;
using Zensys.ZWave.Devices;
using Zensys.Framework.UI.Controls;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class BridgedUPnPDevicesActions: BaseAction
    {
        public BridgedUPnPDevicesActions(ControllerManager controller) : base(controller) { }

        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.ItemColumns.Clear();
            ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.ItemColumns.Add(new ItemColumn("Id", new string[] { "Id" }, OnGetTextId, null));
            ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.ItemColumns.Add(new ItemColumn("Type", new string[] { "Type" }, OnGetTextType, null));
            ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.ItemColumns.Add(new ItemColumn("FriendlyName", new string[] { "FriendlyName" }, OnGetTextFriendlyName, null));
            //ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.ItemColumns.Add(new ItemColumn("FriendlyName", new string[] { "FriendlyName" }, OnGetTextFriendlyName, null)); 
            
            ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.ListViewDeviceList.DataSource = ControllerManager.DocumentModel.BridgedDevices;
            ControllerManager.DocumentModel.BridgedDevicesCurrencyManager.CurrentChanged += new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);
            ControllerManager.DocumentModel.DevicesCurrencyManager.CurrentChanged += new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);
            ControllerManager.DocumentModel.UpnpBinaryLightDevicesCurrencyManager.CurrentChanged += new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);
            OnDocumentModelStateChanged();
        }

        private string OnGetTextId(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextType(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextFriendlyName(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }

        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.DocumentModel.BridgedDevicesCurrencyManager.CurrentChanged -= new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);
            ControllerManager.DocumentModel.DevicesCurrencyManager.CurrentChanged -= new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);
            ControllerManager.DocumentModel.UpnpBinaryLightDevicesCurrencyManager.CurrentChanged -= new EventHandler(BridgedDevicesCurrencyManager_CurrentChanged);

            ControllerManager.MainForm.UPnPBridgedDevicesToolStripMenuItem.Checked = false;
            ControllerManager.BridgedUPnPDevicesForm.Hide();
            e.Cancel = true;
        }

        void BridgedDevicesCurrencyManager_CurrentChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.BridgedUPnPDevicesForm.InvokeRequired)
            {
                ControllerManager.BridgedUPnPDevicesForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
            }
            else
            {
                ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.BindDeviceButton.Enabled =
                    ControllerManager.DocumentModel.CurrentDevice != null &&
                    ControllerManager.DocumentModel.CurrentDevice.IsVirtual &&
                    ControllerManager.DocumentModel.CurrentUpnpBinaryLightDevice != null;

                ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.BindMediaDeviceButton.Enabled =
                    ControllerManager.DocumentModel.CurrentDevice != null &&
                    ControllerManager.DocumentModel.CurrentDevice.IsVirtual &&
                    ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null;

                ControllerManager.BridgedUPnPDevicesForm.BridgedUPnPDeviceView.UnBindDeviceButton.Enabled =
                    ControllerManager.DocumentModel.CurrentBridgedDevice != null;
            }
        }
        
        public void OnBindDeviceClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentDevice != null && 
                ControllerManager.DocumentModel.CurrentDevice.IsVirtual && 
                ControllerManager.DocumentModel.CurrentUpnpBinaryLightDevice != null)
            {
                ControllerManager.DocumentModel.BridgedDevices.Add(new BridgedDevice(ControllerManager.DocumentModel.CurrentDevice, ControllerManager.DocumentModel.CurrentUpnpBinaryLightDevice));
                ControllerManager.LogManager.LogMessage("Node is bounded...");
            }
        }

        public void OnBindMediaDeviceClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentDevice != null &&
                ControllerManager.DocumentModel.CurrentDevice.IsVirtual &&
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null)
            {
                ControllerManager.DocumentModel.BridgedDevices.Add(new BridgedDevice(ControllerManager.DocumentModel.CurrentDevice,
                    ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice));
                ControllerManager.LogManager.LogMessage("Node is bounded...");
            }
        }

        public void OnUnBindDeviceClick(object sender, EventArgs e)
        {
            ControllerManager.DocumentModel.BridgedDevices.Remove(ControllerManager.DocumentModel.CurrentBridgedDevice);
            ControllerManager.DocumentModel.BridgedDevices.ResetBindings();
            ControllerManager.LogManager.LogMessage("Node is unbounded...");
        }
    }
}
