using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using System.Windows.Forms;
using Zensys.ZWave.SerialPortApplication.Devices;
using Zensys.ZWave.Enums;
using Zensys.ZWave.UPnPBridge.Properties;
using System.Threading;
using Zensys.ZWave;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.Framework.UI.Controls;
using System.ComponentModel;
using Zensys.ZWave.UPnPBridge.Models;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.ZWaveHAL.Actions;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class AssociationsFormActions : BaseAction
    {
        AssociationsViewActions AssociationsHAL;
        public AssociationsFormActions(ControllerManager controller)
            : base(controller)
        {
            AssociationsHAL = CustomLoader.CreateAssociationsViewActionsInstance();
            AssociationsHAL.Initialize(controller.LogManager, controller.ExceptionManager, controller.XmlDataManager);
            AssociationsHAL.AddQueueCommandCallback = controller.AddQueueCommand;
            AssociationsHAL.AssociationReport += new EventHandler<AssociationReportEventArgs>(AssociationsHAL_AssociationReport);
            base.ActionsHAL = AssociationsHAL;
        }

        void AssociationsHAL_AssociationReport(object sender, AssociationReportEventArgs e)
        {
            if (e.ParameterValues.Count > 0)
            {
                AssociativeGroup agroup = null;
                foreach (AssociativeGroup ag in ControllerManager.DocumentModel.AssociativeGroups)
                {
                    if (ag.GroupId == e.ParameterValues[0].ByteValueList[0])
                    {
                        agroup = ag;
                        agroup.DeviceIds.Clear();
                        break;
                    }
                }
                if (agroup == null)
                {
                    ControllerManager.DocumentModel.AssociativeGroups.Clear();
                    agroup = ControllerManager.DocumentModel.CreateAssociativeGroup();
                    ControllerManager.DocumentModel.AssociativeGroups.Add(agroup);
                }
                agroup.GroupId = e.ParameterValues[0].ByteValueList[0];
                if (e.ParameterValues[3].ByteValueList != null)
                {
                    foreach (byte id in e.ParameterValues[3].ByteValueList)
                    {
                        agroup.DeviceIds.Add(id);
                    }
                }
            }
        }

        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            DataGridViewColumn colNodeId = new DataGridViewTextBoxColumn();
            DataGridViewColumn colNodeType = new DataGridViewTextBoxColumn();
            DataGridViewBitImageColumn colIsListening = new DataGridViewBitImageColumn();
            DataGridViewBitImageColumn colIsVirtual = new DataGridViewBitImageColumn();

            colNodeId.Name = "colId";
            colNodeId.HeaderText = "Id";
            colNodeId.DataPropertyName = "Id";
            colNodeId.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;


            colNodeType.Name = "colType";
            colNodeType.HeaderText = "Type";
            colNodeType.DataPropertyName = "Type";
            colNodeType.MinimumWidth = 100;
            colNodeType.FillWeight = 100;

            colIsListening.Name = "colIsListening";
            colIsListening.HeaderText = "Listening";
            colIsListening.DataPropertyName = "IsListening";
            colIsListening.Images = ControllerManager.AssociationsForm.associationGridViewControl.Images;
            colIsListening.TrueImageIndex = 0;
            colIsListening.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;

            colIsVirtual.Name = "colIsVirtual";
            colIsVirtual.HeaderText = "Virtual";
            colIsVirtual.DataPropertyName = "IsVirtual";
            colIsVirtual.Images = ControllerManager.AssociationsForm.associationGridViewControl.Images;
            colIsVirtual.TrueImageIndex = 1;
            colIsVirtual.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;

            ControllerManager.AssociationsForm.vcSourceListView.AutoGenerateColumns = false;
            ControllerManager.AssociationsForm.vcSourceListView.Columns.AddRange(new DataGridViewColumn[] { colNodeId, colNodeType, colIsListening, colIsVirtual });
            BindData();


            ControllerManager.AssociationsForm.vcGroupsTreeView.ImageList = ControllerManager.AssociationsForm.associationGridViewControl.Images;
            ControllerManager.AssociationsForm.vcGroupsTreeView.CreatePrefetchedObject = CreatePrefetchedObject;
            ControllerManager.AssociationsForm.vcGroupsTreeView.GetInnerCurrencyManager = GetInnerCurrencyManager;
            ControllerManager.AssociationsForm.vcGroupsTreeView.GetInnerDataSource = GetInnerDataSource;
            ControllerManager.AssociationsForm.vcGroupsTreeView.DataSource = ControllerManager.DocumentModel.AssociativeGroups;

            OnDocumentModelStateChanged();
        }

        private PrefetchedObject CreatePrefetchedObject(object obj)
        {
            PrefetchedObject ret = new PrefetchedObject();
            if (obj is byte)
            {
                ret.Text = String.Format("Node: {0}", ((byte)obj).ToString());
                ret.ImageIndex = 1;
            }
            else if (obj as AssociativeGroup != null)
            {
                ret.Text = String.Format("Group: {0}", ((AssociativeGroup)obj).GroupId.ToString());
                ret.ImageIndex = 2;
            }
            return ret;
        }

        private CurrencyManager GetInnerCurrencyManager(object obj)
        {
            CurrencyManager ret = null;
            if (obj as AssociativeGroup != null)
            {
                ret = ((AssociativeGroup)obj).DeviceIdsCurrencyManager;
            }
            return ret;
        }

        private IBindingList GetInnerDataSource(object obj)
        {
            IBindingList ret = null;
            if (obj as AssociativeGroup != null)
            {
                ret = ((AssociativeGroup)obj).DeviceIds;
            }
            return ret;
        }


        public void nodesGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            AssociativeDevicesCurrencyManager_PositionChanged(sender, EventArgs.Empty);
        }

        public void nodesGridView_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Up || e.KeyCode == Keys.Down || e.KeyCode == Keys.PageUp || e.KeyCode == Keys.PageDown)
            {
                AssociativeDevicesCurrencyManager_PositionChanged(sender, EventArgs.Empty);
            }
        }

        private void AssociativeDevicesCurrencyManager_PositionChanged(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentAssociativeDevice != null)
            {
                ControllerManager.DocumentModel.AssociativeGroups.Clear();
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, string>(AssociationsHAL.RequestAssociationsAction),
                    new object[] { 
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentAssociativeDevice,
                        Resources.MsgGetGroupingsFrame
                    },
                    Resources.MsgGetGroupingsFrame, true, (byte)CommandTypes.None);
            }
        }

        private void BindData()
        {
            ControllerManager.DocumentModel.AssociativeDevices.Ctx = SynchronizationContext.Current;
            ControllerManager.AssociationsForm.vcSourceListView.DataSource = ControllerManager.DocumentModel.AssociativeDevices;
        }

        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.AssociationsToolStripMenuItem.Checked = false;
            ControllerManager.AssociationsForm.Hide();
            e.Cancel = true;
        }
        #endregion

        #region DocumentModel
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        public void groupTreeView_AfterSelect(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.AssociationsForm != null && !ControllerManager.AssociationsForm.IsDisposed)
            {

                if (ControllerManager.AssociationsForm.InvokeRequired)
                {
                    ControllerManager.AssociationsForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.AssociationsForm.vcAssignCheckBox.Enabled =
                    ControllerManager.DocumentModel.Controller != null &&
                    ControllerManager.DocumentModel.CurrentAssociativeDevice != null &&
                    ControllerManager.DocumentModel.CurrentAssociativeGroup != null;

                    ControllerManager.AssociationsForm.vcCreateToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1 &&
                        ControllerManager.DocumentModel.CurrentAssociativeDevice != null &&
                        ControllerManager.DocumentModel.CurrentAssociativeGroup != null;



                    ControllerManager.AssociationsForm.vcGroupsTreeView.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.CurrentAssociativeDevice != null;

                    ControllerManager.AssociationsForm.vcRemoveToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.CurrentAssociativeDevice != null &&
                        ControllerManager.DocumentModel.CurrentAssociativeGroup != null &&
                        ControllerManager.DocumentModel.CurrentAssociativeGroup.CurrentDeviceId != 0;

                    ControllerManager.AssociationsForm.vcSourceListView.Enabled =
                        ControllerManager.DocumentModel.Controller != null;
                }
            }
        }

        #endregion

        #region Other

        public void OnCreateToolStripButtonClick(object sender, EventArgs e)
        {


            if (ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1 &&
                ControllerManager.DocumentModel.CurrentAssociativeDevice != null &&
                ControllerManager.DocumentModel.CurrentAssociativeGroup != null)
            {
                ControllerManager.DoAction(
                   new ProcedureCaller<IController, IDeviceInfo, AssociativeGroup, IDeviceInfo, bool, string, string>(AssociationsHAL.CreateAssociationAction),
                   new object[] { 
                       ControllerManager.DocumentModel.Controller,
                       ControllerManager.DocumentModel.CurrentAssociativeDevice,
                       ControllerManager.DocumentModel.CurrentAssociativeGroup,
                       ControllerManager.DocumentModel.CurrentDevice,
                       ControllerManager.AssociationsForm.vcAssignCheckBox.Checked,
                       Resources.MsgCreateAssociation,
                       Resources.MsgGetGroupingsFrame
                   },
                   Resources.MsgCreateAssociation, true, (byte)CommandTypes.None);
            }
        }

        public void OnRemoveToolStripButtonClick(object sender, EventArgs e)
        {


            if (ControllerManager.DocumentModel.CurrentAssociativeGroup.CurrentDeviceId != 0 &&
                      ControllerManager.DocumentModel.CurrentAssociativeDevice != null &&
                      ControllerManager.DocumentModel.CurrentAssociativeGroup.GroupId != 0)
                ControllerManager.DoAction(
                  new ProcedureCaller<IController, IDeviceInfo, AssociativeGroup, bool, string, string>(AssociationsHAL.RemoveAssociationAction),
                  new object[] {
                      ControllerManager.DocumentModel.Controller, 
                      ControllerManager.DocumentModel.CurrentAssociativeDevice,
                      ControllerManager.DocumentModel.CurrentAssociativeGroup,
                      ControllerManager.AssociationsForm.vcAssignCheckBox.Checked,
                      Resources.MsgRemoveAssociation,
                      Resources.MsgGetGroupingsFrame
                  },
                  Resources.MsgRemoveAssociation, true, (byte)CommandTypes.None);
        }
        #endregion
    }
}
