using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Zensys.PCController.UI
{
    public partial class ProgressForm : Form
    {

        private System.ComponentModel.BackgroundWorker bkgWorker;

        private Delegate mProgressDelegate;
        public Delegate ProgressDelegate
        {
            get { return mProgressDelegate; }
            set { mProgressDelegate = value; }
        }
        private object[] mProgressDelegateParameters = null;
        public object[] ProgressDelegateParameters
        {
            get { return mProgressDelegateParameters; }
            set { mProgressDelegateParameters = value; }
        }
        private object mResult;

        public object Result
        {
            get { return mResult; }
            set { mResult = value; }
        }
	

        private Exception mProgressException;
        public Exception ProgressException
        {
            get { return mProgressException; }
            set { mProgressException = value; }
        }

        public string ProgressInfo
        {
            get { return lblProgressInfo.Text; }
            set
            {
                UpdateLabelText(lblProgressInfo, value);
            }
        }


        private delegate void LabelDelegate(Label label, string text);
        private void UpdateLabelText(Label label, string text)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new LabelDelegate(UpdateLabelText), new object[] { label, text });
            }
            else
            {
                label.Text = text;
            }
        }

        private EventHandler mOnCancel;
        public event EventHandler OnCancel
        {
            add { mOnCancel += value; }
            remove { mOnCancel -= value; }
        }
        private byte mCommandType;
        public byte CommandType
        {
            get { return mCommandType; }
            set { mCommandType = value; }
        }

        public ProgressForm()
        {
            DoubleBuffered = true;
            InitializeComponent();
        }

        private bool mCanCancel;
        public bool CanCancel
        {
            get { return mCanCancel; }
            set
            {
                mCanCancel = value;
                cmdAbort.Visible = mCanCancel;
            }
        }

        private void InitializeBackgoundWorker()
        {
            bkgWorker.DoWork += new DoWorkEventHandler(bkgWorker_DoWork);
            bkgWorker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(bkgWorker_RunWorkerCompleted);
            bkgWorker.ProgressChanged += new ProgressChangedEventHandler(bkgWorker_ProgressChanged);
            bkgWorker.WorkerReportsProgress = true;
            bkgWorker.WorkerSupportsCancellation = true;
        }
        void bkgWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            if (ProgressDelegate != null)
            {
                try
                {
                    if (ProgressDelegateParameters == null)
                    {
                        e.Result = ProgressDelegate.DynamicInvoke(null, null);
                    }
                    else
                    {
                        e.Result = ProgressDelegate.DynamicInvoke(ProgressDelegateParameters);
                    }
                }
                catch (Exception ex)
                {
                    if (ex.InnerException != null)
                        mProgressException = ex.InnerException;
                    else
                        mProgressException = ex;
                }
            }

        }
        void bkgWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
        }
        void bkgWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                throw e.Error;
            }
            ProgressDelegateParameters = null;
            Result = e.Result;
            this.Close();
        }

        private void cmdAbort_Click(object sender, EventArgs e)
        {
            if (mOnCancel != null)
            {
                mOnCancel(this, new EventArgs());
            }
        }

        private void ProgressForm_Load(object sender, EventArgs e)
        {
            bkgWorker = new BackgroundWorker();
            InitializeBackgoundWorker();
            mProgressException = null;
            bkgWorker.RunWorkerAsync();
        }
    }
}