using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;

namespace Zensys.PCController.Models
{
    public class RoutesCollection
    {
        public event EventHandler<EventArgs> SelectedSourceRouteChanged;
        public event EventHandler<EventArgs> SelectedDestinationRouteChanged;
        public event EventHandler<EventArgs> RouteCollectionChanged;
        private List<RouteItem> mSourceRoutes = new List<RouteItem>();
        public List<RouteItem> SourceRoutes
        {
            get { return mSourceRoutes; }
        }
        private List<RouteItem> mDestinationRoutes = new List<RouteItem>();
        public List<RouteItem> DestinationRoutes
        {
            get { return mDestinationRoutes; }
        }
        public void AddSourceRoute(IDeviceInfo device)
        {
            byte? forRemove = null;
            foreach (RouteItem var in mSourceRoutes)
            {
                if (var.Device.Id == device.Id)
                {
                    forRemove = device.Id;
                }
            }
            if (forRemove != null)
            {
                RemoveSourceRoute((byte)forRemove);
            }
            mSourceRoutes.Add(new RouteItem(device));
            if (RouteCollectionChanged != null)
                RouteCollectionChanged(this, EventArgs.Empty);
        }
        public void RemoveSourceRoute(byte deviceId)
        {
            RouteItem routeForDelete = null;
            foreach (RouteItem route in mSourceRoutes)
            {
                if (route.Device.Id == deviceId)
                {
                    routeForDelete = route;
                }
            }
            if (routeForDelete != null)
            {
                mSourceRoutes.Remove(routeForDelete);
                if (RouteCollectionChanged != null)
                    RouteCollectionChanged(this, EventArgs.Empty);
            }
        }
        public void AddDestinationRoute(IDeviceInfo device)
        {
            byte? forRemove = null;
            foreach (RouteItem var in mDestinationRoutes)
            {
                if (var.Device.Id == device.Id)
                {
                    forRemove = device.Id;
                }
            }
            if (forRemove != null)
            {
                RemoveDestinationRoute((byte)forRemove);
            }
            mDestinationRoutes.Add(new RouteItem(device));
            if (RouteCollectionChanged != null)
                RouteCollectionChanged(this, EventArgs.Empty);
        }
        public void RemoveDestinationRoute(byte deviceId)
        {
            RouteItem routeForDelete = null;
            foreach (RouteItem route in mDestinationRoutes)
            {
                if (route.Device.Id == deviceId)
                {
                    routeForDelete = route;
                }
            }
            if (routeForDelete != null)
            {
                mDestinationRoutes.Remove(routeForDelete);
                if (RouteCollectionChanged != null)
                    RouteCollectionChanged(this, EventArgs.Empty);
            }
        }
        public void ClearRoutes()
        {
            mSourceRoutes.Clear();
            mDestinationRoutes.Clear();
            if (RouteCollectionChanged != null)
                RouteCollectionChanged(this, EventArgs.Empty);
        }
        private RouteItem mSelectedSourceRoute;
        public RouteItem SelectedSourceRoute
        {
            get
            {
                return mSelectedSourceRoute;
            }
            set
            {
                mSelectedSourceRoute = value;
                if (SelectedSourceRouteChanged != null)
                {
                    SelectedSourceRouteChanged(this, EventArgs.Empty);
                }
            }
        }
        private RouteItem mSelectedDestinationRoute;
        public RouteItem SelectedDestinationRoute
        {
            get
            {
                return mSelectedDestinationRoute;
            }
            set
            {
                mSelectedDestinationRoute = value;
                if (SelectedDestinationRouteChanged != null)
                {
                    SelectedDestinationRouteChanged(this, EventArgs.Empty);
                }
            }
        }
    }
}
