using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Zensys.PCController.Properties;
using WeifenLuo.WinFormsUI.Docking;
using System.Xml;

namespace Zensys.PCController.Layout
{
    public static class LayoutManager
    {
        internal static void OnLoad(Zensys.PCController.Controllers.ControllerManager Controller, DeserializeDockContent DeserializeDockContent)
        {
            try
            {
                Controller.MainForm.Height = Settings.Default.FormHeight;
                Controller.MainForm.Width = Settings.Default.FormWidth;
                Controller.MainForm.WindowState = Settings.Default.FormState;
            }
            catch (NullReferenceException)
            { 
            }
            TextReader reader = null;
            try
            {
                reader = new StringReader(Settings.Default.UserLayout);
                Controller.MainForm.DockPanelMain.LoadFromXml(reader, DeserializeDockContent, true);
            }
            catch (XmlException)
            {
                reader = new StringReader(Settings.Default.DefaultLayout);
                Controller.MainForm.DockPanelMain.LoadFromXml(reader, DeserializeDockContent, true);
            }
            catch (ArgumentException)
            {
                reader = new StringReader(Settings.Default.DefaultLayout);
                Controller.MainForm.DockPanelMain.LoadFromXml(reader, DeserializeDockContent, true);
            }
            finally
            {
                if (reader != null)
                    reader.Close();
            }

        }

        internal static void OnClose(Zensys.PCController.Controllers.ControllerManager Controller)
        {
            try
            {
                StringBuilder sb = new StringBuilder();
                using (TextWriter writer = new StringWriter(sb))
                {
                    Controller.MainForm.DockPanelMain.SaveAsXml(writer);
                    writer.Close();
                }
                Settings.Default.UserLayout = sb.ToString();
                Settings.Default.Save();
            }
            catch (IOException)
            {
            }
            Settings.Default.FormHeight = Controller.MainForm.Height;
            Settings.Default.FormWidth = Controller.MainForm.Width;
            Settings.Default.FormState = Controller.MainForm.WindowState;
        }
    }
}
