using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.UI;
using System.Windows.Forms;
using Zensys.PCController.Classes;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class RoutingTableFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            RoutingTableForm form = (RoutingTableForm)view;

            //Form
            form.Load += new EventHandler(actions.RoutingTableFormActions.OnFormLoad);
            form.FormClosing += new FormClosingEventHandler(actions.RoutingTableFormActions.OnFormClosing);

            form.ReloadTopologyToolStripMenuItem.Click += new EventHandler(actions.RoutingTableFormActions.OnReloadTopologyClick);
            form.DoRediscoveryToolStripMenuItem.Click += new EventHandler(actions.RoutingTableFormActions.OnDoRediscoveryClick);

            form.PropertyGridNodeTypeColors.PropertyValueChanged += new PropertyValueChangedEventHandler(actions.RoutingTableFormActions.OnNodeTypeColorsPropertyValueChanged);
            form.CheckLinkQualityButton.Click += new EventHandler(actions.RoutingTableFormActions.OnCheckLinkQuality);
        }

        

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            RoutingTableForm form = (RoutingTableForm)view;

            //Form
            form.Load -= new EventHandler(actions.RoutingTableFormActions.OnFormLoad);
            form.FormClosing -= new FormClosingEventHandler(actions.RoutingTableFormActions.OnFormClosing);

            form.ReloadTopologyToolStripMenuItem.Click -= new EventHandler(actions.RoutingTableFormActions.OnReloadTopologyClick);
            form.DoRediscoveryToolStripMenuItem.Click -= new EventHandler(actions.RoutingTableFormActions.OnDoRediscoveryClick);

            form.PropertyGridNodeTypeColors.PropertyValueChanged -= new PropertyValueChangedEventHandler(actions.RoutingTableFormActions.OnNodeTypeColorsPropertyValueChanged);
            form.CheckLinkQualityButton.Click -= new EventHandler(actions.RoutingTableFormActions.OnCheckLinkQuality);
        }

        #endregion
    }
}
