using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class CommandClassFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            CommandClassForm form = (CommandClassForm)view;

            //Form
            form.Load += new EventHandler(actions.CommandClassFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.CommandClassFormActions.OnFormClosing);
            form.vcCommandClassesComboBox.DropDown += new EventHandler(actions.CommandClassFormActions.OnCommandClassesComboBox_DropDown);

            //Controls
            form.vcCommandClassesComboBox.SelectedIndexChanged += new EventHandler(actions.CommandClassFormActions.OnCommandClassesSelectedIndexChanged);
            form.vcCommandNameComboBox.SelectedIndexChanged += new EventHandler(actions.CommandClassFormActions.OnCommandSelectedIndexChanged);

            form.vcSendButton.Click += new EventHandler(actions.CommandClassFormActions.OnCommandSendClick);
            form.vcSendMetaButton.Click += new EventHandler(actions.CommandClassFormActions.OnCommandSendMetaClick);
            form.vcSendCRC16Button.Click += new EventHandler(actions.CommandClassFormActions.OnCommandSendCRC16Click);
            form.vcReloadXmlButton.Click += new EventHandler(actions.CommandClassFormActions.OnCommandReloadXmlClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.CommandClassFormActions.OnDocumentModelStateChanged);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            CommandClassForm form = (CommandClassForm)view;

            //Form
            form.Load -= new EventHandler(actions.CommandClassFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.CommandClassFormActions.OnFormClosing);
            form.vcCommandClassesComboBox.DropDown -= new EventHandler(actions.CommandClassFormActions.OnCommandClassesComboBox_DropDown);

            //Controls
            form.vcCommandClassesComboBox.SelectedIndexChanged -= new EventHandler(actions.CommandClassFormActions.OnCommandClassesSelectedIndexChanged);
            form.vcCommandNameComboBox.SelectedIndexChanged -= new EventHandler(actions.CommandClassFormActions.OnCommandSelectedIndexChanged);

            form.vcSendButton.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandSendClick);
            form.vcSendMetaButton.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandSendMetaClick);
            form.vcSendCRC16Button.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandSendCRC16Click);
            form.vcReloadXmlButton.Click -= new EventHandler(actions.CommandClassFormActions.OnCommandReloadXmlClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.CommandClassFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
