using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Controllers;
using Zensys.ZWave.Enums;
using Zensys.ZWave.ZWaveHAL.Actions;

namespace Zensys.PCController.Classes
{
    /// <summary>
    /// Base class for actions. Provides methods that extends <see cref="ControllerManager"/> 
    /// </summary>
    public class BaseAction
    {
        private ControllerManager mControllerManager;
        internal ControllerManager ControllerManager
        {
            get { return mControllerManager; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BaseAction"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public BaseAction(ControllerManager controllerManager)
        {
            mControllerManager = controllerManager;
        }

        public bool IsControllerLibrary(Libraries library)
        {
            return library == Libraries.ControllerStaticLib || library == Libraries.ControllerPortableLib;
        }

        private ActionsHAL mActionsHAL;
        public ActionsHAL ActionsHAL
        {
            get { return mActionsHAL; }
            set { mActionsHAL = value; }
        }
	
    }
}
