using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Controllers;
using Zensys.ZWave.SerialPortApplication.Devices;
using Zensys.ZWave;
using Zensys.ZWave.Devices;
using Zensys.PCController.Properties;
using Zensys.ZWave.Enums;
using System.Windows.Forms;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.ZWaveHAL.Actions;
using Zensys.ZWave.Application;

namespace Zensys.PCController.Actions
{
    public class CommandClassFormActions : BaseAction
    {
        public CommandClassViewActions CommandClassHAL;
        public CommandClassFormActions(ControllerManager controller)
            : base(controller)
        {
            CommandClassHAL = CustomLoader.CreateCommandClassViewActionsInstance();
            CommandClassHAL.Initialize(controller.LogManager, controller.ExceptionManager, controller.XmlDataManager);
            CommandClassHAL.AddQueueCommandCallback = controller.AddQueueCommand;
        }

        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.DocumentModel.DevicesCurrencyManager.ListChanged += DevicesCollection_SelectedDeviceChanged;
            ControllerManager.DocumentModel.DevicesCurrencyManager.CurrentChanged += DevicesCollection_SelectedDeviceChanged;
            ControllerManager.DocumentModel.DevicesCurrencyManager.PositionChanged += DevicesCollection_SelectedDeviceChanged;
            OnDocumentModelStateChanged();
        }

        public void OnCommandClassesComboBox_DropDown(object sender, EventArgs e)
        {
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Count == 0)
            {
                ReBuildList();
            }
        }


        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.CmdClassToolStripMenuItem.Checked = false;
            ControllerManager.CommandClassForm.Hide();
            e.Cancel = true;
        }
        #endregion

        #region DocumentModel
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }
        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.CommandClassForm != null && !ControllerManager.CommandClassForm.IsDisposed)
            {

                if (ControllerManager.CommandClassForm.InvokeRequired)
                {
                    ControllerManager.CommandClassForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.CommandClassForm.vcCommandClassesComboBox.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcCommandNameComboBox.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcParametersGrid.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;
                    ControllerManager.CommandClassForm.vcSendButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1 &&
                        ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                        ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null;
                    ControllerManager.CommandClassForm.vcSendMetaButton.Enabled = ControllerManager.CommandClassForm.vcSendButton.Enabled;
                    ControllerManager.CommandClassForm.vcSendCRC16Button.Enabled = ControllerManager.CommandClassForm.vcSendButton.Enabled;
                }
            }
        }
        #endregion

        #region Other
        public void OnCommandClassesSelectedIndexChanged(object sender, EventArgs e)
        {
            ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem is CommandClass)
            {
                CommandClass commadClass = ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem as CommandClass;
                if (commadClass.Command != null)
                {
                    foreach (Command cmd in commadClass.Command)
                    {
                        ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Add(cmd);
                    }
                }
            }
            OnDocumentModelStateChanged();
        }
        public void OnCommandSelectedIndexChanged(object sender, EventArgs e)
        {
            ParameterWrapperCollection parameters = new ParameterWrapperCollection();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem is Command)
            {
                Command command = ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem as Command;
                if (command.Param != null)
                {
                    foreach (Param parameter in command.Param)
                    {
                        parameters.Add(ParamValue.CreateParamValue(parameter));
                    }
                }
                //parameters.Sort();
            }
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = parameters;
            OnDocumentModelStateChanged();
        }

        public void OnCommandReloadXmlClick(object sender, EventArgs e)
        {
            ControllerManager.ReloadXml();
            ReBuildList();
        }

        public void OnCommandSendClick(object sender, EventArgs e)
        {
            CommandClass cmdClass;
            Command cmd;
            List<ParamValue> parameterValues;
            PrepareCommandData(out cmdClass, out cmd, out parameterValues);

            if (cmdClass != null && cmd != null && ControllerManager.DocumentModel.CurrentDevice != null)
            {
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, CommandClass, Command, List<ParamValue>, string>(CommandClassHAL.SendCommand),
                    new object[]{
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice,
                        cmdClass,
                        cmd,
                        parameterValues,
                        Resources.MsgSendCommand},
                    Resources.MsgSendCommand, true, (byte)CommandTypes.CmdZWaveSendData);
            }
        }

        private void PrepareCommandData(out CommandClass cmdClass, out Command cmd, out List<ParamValue> parameterValues)
        {
            cmdClass = null;
            cmd = null;
            parameterValues = null;
            ParameterWrapperCollection parameters = null;
            if (ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem is CommandClass &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem != null &&
                ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem is Command &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject != null &&
                ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject is ParameterWrapperCollection)
            {
                cmdClass = (CommandClass)ControllerManager.CommandClassForm.vcCommandClassesComboBox.SelectedItem;
                cmd = (Command)ControllerManager.CommandClassForm.vcCommandNameComboBox.SelectedItem;
                parameters = (ParameterWrapperCollection)ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject;
                if (parameters != null)
                {
                    parameterValues = parameters.ToParamValueList();
                }
            }
        }

        public void OnCommandSendMetaClick(object sender, EventArgs e)
        {
            CommandClass cmdClass;
            Command cmd;
            List<ParamValue> parameterValues;
            PrepareCommandData(out cmdClass, out cmd, out parameterValues);

            if (cmdClass != null && cmd != null && ControllerManager.DocumentModel.CurrentDevice != null)
            {
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, CommandClass, Command, List<ParamValue>, string>(CommandClassHAL.SendMetaCommand),
                    new object[]{
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice,
                        cmdClass,
                        cmd,
                        parameterValues,
                        Resources.MsgSendCommand},
                    Resources.MsgSendCommand, true, (byte)CommandTypes.CmdZWaveSendDataMeta);
            }
        }

        public void OnCommandSendCRC16Click(object sender, EventArgs e)
        {
            CommandClass cmdClass;
            Command cmd;
            List<ParamValue> parameterValues;
            PrepareCommandData(out cmdClass, out cmd, out parameterValues);
            if (cmdClass != null && cmd != null && ControllerManager.DocumentModel.CurrentDevice != null)
            {
                ControllerManager.DoAction(
                    new ProcedureCaller<IController, IDeviceInfo, CommandClass, Command, List<ParamValue>, string>(CommandClassHAL.SendCRC16Command),
                    new object[]{
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice,
                        cmdClass,
                        cmd,
                        parameterValues,
                        Resources.MsgSendCommand},
                    Resources.MsgSendCommand, true, (byte)CommandTypes.CmdZWaveSendData);
            }
        }
        #endregion

        private void DevicesCollection_SelectedDeviceChanged(object sender, EventArgs e)
        {
            ReBuildList();
        }

        private delegate void ReBuildListDelegate();
        private void ReBuildList()
        {
            if (ControllerManager.CommandClassForm.InvokeRequired)
            {
                ControllerManager.CommandClassForm.Invoke(new ReBuildListDelegate(ReBuildList));
            }
            else
            {
                BuildList();
            }
        }
        private void BuildList()
        {
            ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcCommandNameComboBox.Items.Clear();
            ControllerManager.CommandClassForm.vcParametersGrid.SelectedObject = null;
            if (ControllerManager.DocumentModel.CurrentDevice != null)
            {
                byte[] cmdClasses = new byte[0];
                if (ControllerManager.DocumentModel.CurrentDevice.SupportedCommandClasses != null)
                {
                    byte nodeId = ControllerManager.DocumentModel.CurrentDevice.Id;
                    byte basicCC = ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_BASIC");
                    if (!ControllerManager.DocumentModel.Controller.CommandClassesStore.IsSupported(nodeId, basicCC))
                    {
                        FillCC(ControllerManager.DocumentModel.CurrentDevice.SupportedCommandClasses, basicCC);
                    }
                    else
                    {
                        FillCC(ControllerManager.DocumentModel.CurrentDevice.SupportedCommandClasses);
                    }
                }
            }
        }

        private void FillCC(byte[] cmdClasses, params byte[] addCmdClasses)
        {
            if (addCmdClasses != null && addCmdClasses.Length > 0)
            {
                foreach (byte cmdClass in addCmdClasses)
                {
                    List<CommandClass> commandClasses = ControllerManager.XmlDataManager.FindCommandClasses(cmdClass);
                    if (commandClasses != null)
                    {
                        foreach (CommandClass var in commandClasses)
                        {
                            ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Add(var);
                        }
                    }
                }
            }
            foreach (byte cmdClass in cmdClasses)
            {
                List<CommandClass> commandClasses = ControllerManager.XmlDataManager.FindCommandClasses(cmdClass);
                if (commandClasses != null)
                {
                    foreach (CommandClass var in commandClasses)
                    {
                        ControllerManager.CommandClassForm.vcCommandClassesComboBox.Items.Add(var);
                    }
                }
            }
        }
    }
}