using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Devices;
using Zensys.ZWave.InstallerTool.Classes;

namespace Zensys.ZWave.InstallerTool.UI
{
    public partial class SettingsForm : Form
    {

        private EventHandler mOnLoadInterfaces;
        public event EventHandler OnLoadInterfaces
        {
            add { mOnLoadInterfaces += value; }
            remove { mOnLoadInterfaces -= value; }
        }
        private EventHandler mOnDetectInterface;
        public event EventHandler OnDetectInterface
        {
            add { mOnDetectInterface += value; }
            remove { mOnDetectInterface -= value; }
        }

        public SettingsForm()
        {
            DoubleBuffered = true;
            InitializeComponent();
        }

        private IInstallerController mSelectedDevice = null;
        public IInstallerController SelectedDevice
        {
            get { return mSelectedDevice; }
            set { mSelectedDevice = value; }
        }

        private string mSelectedDeviceId = null;
        public string SelectedDeviceId
        {
            get { return mSelectedDeviceId; }
            set { mSelectedDeviceId = value; }
        }

        #region View Members

        public System.Windows.Forms.ListBox InterfacesListBox
        {
            get { return interfacesListBox; }
        }

        public Label NoCommInterfacesLabel
        {
            get { return lblEmpty; }
        }

        #endregion

        private void SettingsForm_Load(object sender, EventArgs e)
        {
            if (mOnLoadInterfaces != null)
            {
                mOnLoadInterfaces(sender, e);
            }
        }

        private void cmdDetect_Click(object sender, EventArgs e)
        {
            if (mOnDetectInterface != null)
            {
                mOnDetectInterface(this, new EventArgs());
            }
        }

        private void interfacesListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (InterfacesListBox.SelectedItem != null)
            {
                SelectedDevice = ((DeviceWrapper)InterfacesListBox.SelectedItem).Device;
                SelectedDeviceId = ((DeviceWrapper)InterfacesListBox.SelectedItem).PortInfo.DeviceID;
            }
        }
    }
}