using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.InstallerTool.Models
{
    public class DevicesCollection
    {
        public event EventHandler<EventArgs> SelectedDeviceChanged;
        public event EventHandler<EventArgs> DeviceCollectionChanged;

        private DataSourceStates mState;
        public DataSourceStates State
        {
            get { return mState; }
        }

        public void BeginUpdate()
        {
            if (State != DataSourceStates.Updating)
            {
                mState = DataSourceStates.Updating;
            }
            else
            {
                throw new InvalidOperationException("DataSource is in updating state");
            }
        }

        public void EndUpdate()
        {
            if (State == DataSourceStates.Updating)
            {
                mState = DataSourceStates.None;
                if (DeviceCollectionChanged != null)
                {
                    DeviceCollectionChanged(this, EventArgs.Empty);
                }
            }
            else
            {
                throw new InvalidOperationException("DataSource is not in updating state");
            }

        }

        private List<DeviceItem> mDevices = new List<DeviceItem>();
        public List<DeviceItem> Devices
        {
            get { return mDevices; }
        }

        public void AddDevice(IDevice device)
        {
            lock (mDevices)
            {
                byte? forRemoveId = null;
                foreach (DeviceItem var in mDevices)
                {
                    if (var.Device.Id == device.Id)
                    {
                        forRemoveId = device.Id;
                    }
                }
                if (forRemoveId != null)
                {
                    RemoveDevice((byte)forRemoveId);
                }
                mDevices.Add(new DeviceItem(device, false));
                if (State != DataSourceStates.Updating && DeviceCollectionChanged != null)
                    DeviceCollectionChanged(this, EventArgs.Empty);
            }
        }

        public void RemoveDevice(byte deviceId)
        {
            lock (mDevices)
            {
                DeviceItem deviceForDelete = null;
                foreach (DeviceItem device in mDevices)
                {
                    if (device.Device.Id == deviceId)
                    {
                        deviceForDelete = device;
                    }
                }
                if (deviceForDelete != null)
                {
                    if (SelectedDevice != null && SelectedDevice.Device.Id == deviceForDelete.Device.Id)
                        SelectedDevice = null;
                    mDevices.Remove(deviceForDelete);
                    if (State != DataSourceStates.Updating && DeviceCollectionChanged != null)
                        DeviceCollectionChanged(this, EventArgs.Empty);
                }
            }
        }

        public void ClearDevices()
        {
            lock (mDevices)
            {
                mDevices.Clear();
                SelectedDevice = null;
                if (State != DataSourceStates.Updating && DeviceCollectionChanged != null)
                    DeviceCollectionChanged(this, EventArgs.Empty);
            }
        }

        private DeviceItem mSelectedDevice;
        public DeviceItem SelectedDevice
        {
            get
            {
                return mSelectedDevice;
            }
            set
            {
                mSelectedDevice = value;
                if (SelectedDeviceChanged != null)
                {
                    SelectedDeviceChanged(this, EventArgs.Empty);
                }
            }
        }

        internal void MarkFailedNode(byte nodeId)
        {
            lock (mDevices)
            {
                foreach (DeviceItem var in mDevices)
                {
                    if (var.Device.Id == nodeId)
                    {
                        var.IsFailed = true;
                        if (State != DataSourceStates.Updating && DeviceCollectionChanged != null)
                            DeviceCollectionChanged(this, EventArgs.Empty);
                        break;
                    }
                }
            }
        }
    }
}
