using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.Interfaces;
using Zensys.ZWave.InstallerTool.Classes;
using Zensys.ZWave.InstallerTool.UI;
using Zensys.ZWave.InstallerTool.Models;

namespace Zensys.ZWave.InstallerTool.Dispatchers
{
    public class ControllerFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load += new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.controllerViewControl.vcBtnLoadCClassesFromDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.controllerViewControl.vcBtnSaveCClassesToDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);

            form.vcSucRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.vcSisRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.vcNoneRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click += new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }



        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load -= new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.controllerViewControl.vcBtnLoadCClassesFromDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.controllerViewControl.vcBtnSaveCClassesToDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);

            form.vcSucRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.vcSisRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.vcNoneRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click -= new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }

        #endregion

    }
}
