using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.InstallerTool.Models;
using Zensys.Framework;

namespace Zensys.ZWave.InstallerTool.Controls.Drawing
{
    public partial class TopologyMapControl : UserControl
    {
        public TopologyMapControl()
        {
            InitializeComponent();
            DoubleBuffered = true;
            SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            SetStyle(ControlStyles.UserPaint, true);
            SetStyle(ControlStyles.ResizeRedraw, true);
        }

        public TopologyMapItemCollection DataSource
        {
            get { return canvas.DataSource; }
            set { canvas.DataSource = value; }
        }
        public TopologyMapCanvas Canvas
        {
            get { return canvas; }
        }
        public TopologyMapElement SelectedElement
        {
            get { return canvas.SelectedElement; }
        }

        private void TopologyMapControl_Scroll(object sender, ScrollEventArgs e)
        {
            this.Invalidate(true);
        }

        private void TopologyMapControl_SizeChanged(object sender, EventArgs e)
        {
            //Canvas.SetSize(this);
        }
    }
}
