using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.Controllers;
using Zensys.ZWave.InstallerTool.Actions;

namespace Zensys.ZWave.InstallerTool.Classes
{
    public class ActionCollection : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ActionCollection"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ActionCollection(ControllerManager controller)
            : base(controller)
        {
        }

        private MainFormActions mMainFormActions;
        private LogFormActions mLogFormActions;
        private ControllerFormActions mControllerFormActions;
        private NodeFormActions mNodeFormActions;
        private CommonActions mCommonActions;
        private RoutingTableFormActions mRoutingTableFormActions;

        /// <summary>
        /// Gets or sets the routing table form actions.
        /// </summary>
        /// <value>The routing table form actions.</value>
        public RoutingTableFormActions RoutingTableFormActions
        {
            get
            {
                if (mRoutingTableFormActions == null) mRoutingTableFormActions = new RoutingTableFormActions(this.ControllerManager);
                return mRoutingTableFormActions;
            }
        }
        /// <summary>
        /// Gets the common actions.
        /// </summary>
        /// <value>The common actions.</value>
        public CommonActions CommonActions
        {
            get
            {
                if (mCommonActions == null) mCommonActions = new CommonActions(this.ControllerManager);
                return mCommonActions;
            }
        }
        /// <summary>
        /// Gets the Main Form actions.
        /// </summary>
        /// <value>The Main Form actions.</value>
        public MainFormActions MainFormActions
        {
            get
            {
                if (mMainFormActions == null) mMainFormActions = new MainFormActions(this.ControllerManager);
                return mMainFormActions;
            }
        }

        /// <summary>
        /// Gets the Log Form actions.
        /// </summary>
        /// <value>The Log Form actions.</value>
        public LogFormActions LogFormActions
        {
            get
            {
                if (mLogFormActions == null) mLogFormActions = new LogFormActions(this.ControllerManager);
                return mLogFormActions;
            }
        }

        /// <summary>
        /// Gets the controller form actions.
        /// </summary>
        /// <value>The controller form actions.</value>
        public ControllerFormActions ControllerFormActions
        {
            get
            {
                if (mControllerFormActions == null) mControllerFormActions = new ControllerFormActions(this.ControllerManager);
                return mControllerFormActions;
            }

        }

        /// <summary>
        /// Gets the node form actions.
        /// </summary>
        /// <value>The node form actions.</value>
        public NodeFormActions NodeFormActions
        {
            get
            {
                if (mNodeFormActions == null) mNodeFormActions = new NodeFormActions(this.ControllerManager);
                return mNodeFormActions;
            }
        }
    }
}
