using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Collections;
using System.Reflection;


namespace Zensys.Framework.UI.Controls
{
    public class TreeInfoView : TreeView
    {
        public delegate void BuildTreeDelegate();
        public delegate PrefetchedObject CreatePrefetchedObjectDelegate(object currentObject);
        private IBindingList mDataSource;
        private CurrencyManager mCurrencyManager = null;
        private CreatePrefetchedObjectDelegate mCreatePrefetchedObject;
        public CreatePrefetchedObjectDelegate CreatePrefetchedObject
        {
            set { mCreatePrefetchedObject = value; }
        }

        [Category("Data")]
        public IBindingList DataSource
        {
            get
            {
                return mDataSource;
            }
            set
            {
                if (value != null)
                {
                    mDataSource = value;
                    mCurrencyManager = (CurrencyManager)this.BindingContext[value];
                    mCurrencyManager.CurrentChanged += new EventHandler(mCurrencyManager_CurrentChanged);
                    mDataSource.ListChanged += new ListChangedEventHandler(mDataSource_ListChanged);
                    BuildTree();
                }
                else
                {
                    this.mCurrencyManager = null;
                    this.Nodes.Clear();
                }
            }
        }

        void mDataSource_ListChanged(object sender, ListChangedEventArgs e)
        {
            BuildTree();
        }

        void mCurrencyManager_CurrentChanged(object sender, EventArgs e)
        {
            BuildTree();
        }


        public void BuildTree()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new BuildTreeDelegate(BuildTree));
            }
            else
            {
                BeginUpdate();
                if (this.Nodes != null && this.Nodes.Count > 0)
                {
                    GetNodesVisibleState(this.Nodes[0].Nodes);
                }
                this.Nodes.Clear();
                if (mCurrencyManager.Position != -1)
                {
                    PrefetchedObject prefetchedObject = mCreatePrefetchedObject(mCurrencyManager.Current);
                    TreeNode rootNode = new TreeNode(prefetchedObject.Text);
                    rootNode.ImageIndex = prefetchedObject.ImageIndex;
                    rootNode.SelectedImageIndex = prefetchedObject.ImageIndex;
                    Nodes.Add(rootNode);
                    AddSubNodes(rootNode, prefetchedObject.Children);
                }
                if (this.Nodes != null && this.Nodes.Count > 0)
                {
                    SetNodesVisibleState(this.Nodes[0].Nodes);
                    this.Nodes[0].Expand();
                }
                //ExpandAll();
                
                EndUpdate();
            }
        }

        private List<bool> nodesVisibilityVector = new List<bool>();

        private void SetNodesVisibleState(TreeNodeCollection treeNodeCollection)
        {
            int position = 0;
            if (nodesVisibilityVector.Count > 0)
            {
                foreach (TreeNode node in treeNodeCollection)
                {
                    if (nodesVisibilityVector.Count > position && nodesVisibilityVector[position])
                    {
                        node.Expand();
                    }
                    else
                    {
                        node.Collapse();
                    }
                    position++;
                }
            }
        }

        private void GetNodesVisibleState(TreeNodeCollection treeNodeCollection)
        {
            nodesVisibilityVector.Clear();
            if (treeNodeCollection != null)
            {
                foreach (TreeNode node in treeNodeCollection)
                {
                    nodesVisibilityVector.Add(node.IsExpanded);
                }
            }
        }

        private void AddSubNodes(TreeNode rootNode, List<PrefetchedObject> list)
        {
            foreach (PrefetchedObject var in list)
            {
                TreeNode node = new TreeNode(var.Text);
                node.ImageIndex = var.ImageIndex;
                node.SelectedImageIndex = var.ImageIndex;
                rootNode.Nodes.Add(node);
                AddSubNodes(node, var.Children);
            }
        }

        private void InitializeComponent()
        {
        }
    }
}
