using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms.Design;
using System.Drawing.Design;
using System.ComponentModel;
using Zensys.ZWave.ZWaveHAL.UI;
using Zensys.ZWave.Application;


namespace Zensys.ZWave.ZWaveHAL
{
    public class VariantGroupEditor : UITypeEditor
    {
        IWindowsFormsEditorService edSvc;
        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.Modal;
        }
        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
        {
            edSvc = (IWindowsFormsEditorService)provider.GetService(typeof(IWindowsFormsEditorService));
            if (edSvc != null && context.Instance != null && context.Instance is ParameterWrapperCollection)
            {
                VariantGroupEditorForm form = new VariantGroupEditorForm();
                form.Obj = (ParamValue)value;
                if (edSvc.ShowDialog(form) == System.Windows.Forms.DialogResult.OK)
                {
                    value = form.Obj;
                }
            }
            return value;

        }
    }
}
