using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL.Actions
{
    public class ControllerViewActions : ActionsHAL
    {
        /// <summary>
        /// SUC capabilities used in ZW_EnableSUC - Enable basic SUC functionality
        /// </summary>
        private const int ZW_SUC_FUNC_BASIC_SUC = 0x00;      //    ZW_SUC_FUNC_BASIC_SUC
        /// <summary>
        /// SUC capabilities used in ZW_EnableSUC - Enable basis SUC and NodeID
        /// Server functionalities
        /// </summary>
        private const int ZW_SUC_FUNC_NODEID_SERVER = 0x01;  // ZW_SUC_FUNC_NODEID_SERVER

        public event EventHandler AfterReReadController;
        public ControllerViewActions(BaseEntryPointHAL entryPoint)
            : base(entryPoint)
        {
        }

        public void ShiftControllerAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.ControllerChange(ControllerChangeMode.Start);
                controller.StopRequest((byte)CommandTypes.CmdZWaveControllerChange);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void ResetControllerAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.SetDefault();
                controller.CommandClassesStore.ClearEEPROMData();
                //if (mEntryPointHAL.CustomCommandClassesStore != null)
                //{
                //    mEntryPointHAL.CustomCommandClassesStore.ClearEEPROMData();
                //}
                mEntryPointHAL.CustomReset();
                controller.GetVersion();
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void InitLearnModeAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        

        public LearnMode SetLearnModeAction(IController controller)
        {
            LearnMode lmode = LearnMode.Unknown;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                lmode = controller.SetLearnMode(true);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            return lmode;
        }

        public void RequestNodesAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                foreach (IDeviceInfo node in controller.IncludedNodes)
                {
                    System.Diagnostics.Debug.WriteLine("node.IsSlaveApi: " + node.IsSlaveApi.ToString());

                    if (node.Id != controller.Id)
                    {
                        IDeviceInfo reqNode = controller.RequestNodeInfo(node.Id);
                        if (reqNode != null)
                        {
                            System.Diagnostics.Debug.WriteLine("Requested Node Id: " + reqNode.Id.ToString());
                            if (reqNode.SupportedCommandClasses != null)
                            {
                                foreach (byte b in reqNode.SupportedCommandClasses)
                                {
                                    controller.CommandClassesStore.Store(reqNode.Id, b);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void RequestNetworkUpdateAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.RequestNetworkUpdate();
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void CreateNewPrimaryAction(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.CreateNewPrimaryCtrl(CreateNewPrimaryControllerMode.Start);
                controller.StopRequest((byte)CommandTypes.CmdZWaveCreateNewPrimary);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void LoadCClassesFromDeviceMemory(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.CommandClassesStore.LoadAllFromDeviceMemory();
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void SaveCClassesToDeviceMemory(IController controller)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.CommandClassesStore.StoreAllToDeviceMemory();
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void AssignNetworkRoleOptionAction(IController controller, bool sucState, byte select_SUC_or_SIS)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                controller.SetSelfAsSUC(sucState, select_SUC_or_SIS);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public void EnableSucSisAction(IController controller, ControllerRoles controllerRole)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                switch (controllerRole)
                {
                    case ControllerRoles.SIS:
                        {
                            controller.EnableSUC(true, ZW_SUC_FUNC_NODEID_SERVER);
                        } break;
                    case ControllerRoles.SUC:
                        {
                            controller.EnableSUC(true, ZW_SUC_FUNC_BASIC_SUC);

                        } break;
                    case ControllerRoles.None:
                        {
                            controller.EnableSUC(false, ZW_SUC_FUNC_BASIC_SUC);
                        } break;
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public virtual void ProcessCustomAfterLearnModeActions(IController controller)
        {

        }
    }
}
