using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.Events
{
    /// <summary>
    /// Provides data for <see cref="Zensys.ZWave.Devices.IDevice.ApplicationCommandHandlerEvent"/> event.
    /// </summary>
    public class NodeStatusChangedEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceAppCommandHandlerEventArgs"/> class.
        /// </summary>
        /// <param name="frameBuffer">The frame buffer.</param>
        /// <param name="sourceNodeId">The source node id.</param>
        /// <param name="commandType">Type of the command.</param>
        /// <param name="status">The status.</param>
        public NodeStatusChangedEventArgs(byte[] data, byte sourceNodeId, CommandTypes commandType, NodeStatuses status, IDeviceInfo deviceInfo)
        {
            Data = data;
            SourceNodeId = sourceNodeId;
            CommandType = commandType;
            Status = status;
            DeviceInfo = deviceInfo;
        }

        /// <summary>
        /// 
        /// </summary>
        public IDeviceInfo DeviceInfo;

        /// <summary>
        /// 
        /// </summary>
        public byte[] Data;
        /// <summary>
        /// 
        /// </summary>
        public byte SourceNodeId;
        /// <summary>
        /// 
        /// </summary>
        public CommandTypes CommandType;
        /// <summary>
        /// 
        /// </summary>
        public NodeStatuses Status;
    }
}
