using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Mode enumeration.
    /// </summary>
    public enum Mode
    {
        /// <summary>
        /// None
        /// </summary>
        None = 0x00,
        /// <summary>
        /// Mode parameters to ZWaveAddNodeToNetwork and ZWaveRemoveNodeFromNetwork  - Add / Remove any node to the network.
        /// </summary>
        NodeAny = 0x01,
        /// <summary>
        /// Mode parameters to ZWaveAddNodeToNetwork, ZWaveRemoveNodeFromNetwork, ZWaveCreateNewPrimary, ZWaveControllerChange - Add a controller to the network.
        /// </summary>
        NodeController = 0x02,
        /// <summary>
        /// Mode parameters to ZWaveAddNodeToNetwork ,ZWaveRemoveNodeFromNetwork- Add/Remove a slave node to/from the network.
        /// </summary>
        NodeSlave = 0x03,
        /// <summary>
        /// Mode parameters to ZWaveAddNodeToNetwork and ZWaveRemoveNodeFromNetwork.
        /// </summary>
        NodeExisting = 0x04,
        /// <summary>
        ///Stop learn mode without reporting an error.ZWaveAddNodeToNetwork, ZWaveRemoveNodeFromNetwork and ZWaveCreateNewPrimary.
        /// </summary>
        NodeStop = 0x05,
        /// <summary>
        /// Mode parameters to ZWaveAddNodeToNetwork, ZWaveCreateNewPrimary.
        /// </summary>
        NodeStopFailed = 0x06,
        /// <summary>
        /// Mode option bit to ZWaveAddNodeToNetwork - Network Wide Inclusion
        /// </summary>
        NodeOptionNetworkWide = 0x40,
        /// <summary>
        /// Mode option bit to ZWaveAddNodeToNetwork - High power inclusion
        /// </summary>
        NodeOptionHighPower = 0x80
      }
}
