using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Command Types enumeration.
    /// </summary>
    public enum CommandTypes : byte
    {
        /// <summary>
        /// None.
        /// </summary>
        None = 0x00,
        /// <summary>
        /// Command to initialize Zerial API data.
        /// </summary>
        CmdSerialApiGetInitData = 0x02,
        /// <summary>
        /// Command to generate the Node Information frame and to save information about Node capabilities.
        /// </summary>
        CmdSerialApiApplNodeInformation = 0x03,
        /// <summary>
        /// Command to handle Z-Wave protocol ApplicationCommandHandler function.
        /// </summary>
        CmdApplicationCommandHandler = 0x04,
        /// <summary>
        /// Command to get bitmask containing the capabilities of the controller.
        /// </summary>
        CmdZWaveGetControllerCapabilities = 0x05,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdSerialApiSetTimeouts = 0x06,
        /// <summary>
        /// Command to get Serial API capabilities.
        /// </summary>
        CmdSerialApiGetCapabilities = 0x07,
        /// <summary>
        /// Command to make the Z-Wave module do a software reset.
        /// </summary>
        CmdSerialApiSoftReset = 0x08,
        /// <summary>
        /// Command to power down the RF when not in use e.g. expects nothing to be received.
        /// </summary>
        CmdZWaveSetRFReceiveMode = 0x10,
        /// <summary>
        /// Command to set the Z-Wave module's CPU in sleep mode until woken by an interrupt.
        /// </summary>
        CmdZWaveSetSleepMode = 0x11,
        /// <summary>
        /// Command to create and transmit a "Node Information" frame.
        /// </summary>
        CmdZWaveSendNodeInformation = 0x12,
        /// <summary>
        /// Command to transmit the data buffer to a single Z-Wave Node or all Z-Wave Nodes (broadcast).
        /// </summary>
        CmdZWaveSendData = 0x13,
        /// <summary>
        /// Command to transmit the data buffer to a single Z-Wave Node or all Z-Wave Nodes (broadcast).
        /// </summary>
        CmdZWaveSendData_Bridge = 0xA9,
        /// <summary>
        /// Command to transmit the data buffer to a list of Z-Wave Nodes (multicast frame).
        /// <br/>NOTE: This function is implemented in Z-Wave Controller APIs, Z-Wave Routing Slave API and Z-Wave Enhanced Slave API only.
        /// </summary>
        CmdZWaveSendDataMulti = 0x14,
        /// <summary>
        /// Command to transmit the data buffer to a list of Z-Wave Nodes (multicast frame).
        /// <br/>NOTE: This function is implemented in Z-Wave Controller APIs, Z-Wave Routing Slave API and Z-Wave Enhanced Slave API only.
        /// </summary>
        CmdZWaveSendDataMulti_Bridge = 0xAB,
        /// <summary>
        /// Command to get the Z-Wave basis API library version.
        /// </summary>
        CmdZWaveGetVersion = 0x15,
        /// <summary>
        /// Command to abort the ongoing transmit started with <see cref="CmdZWaveSendData"/> or <see cref="CmdZWaveSendDataMulti"/>.
        /// </summary>
        CmdZWaveSendDataAbort = 0x16,
        /// <summary>
        /// Command to set the power level used in RF transmitting.
        /// </summary>
        CmdZWaveRFPowerLevelSet = 0x17,
        /// <summary>
        /// Command to transmit streaming or bulk data in the Z-Wave network.
        /// <br/>NOTE: This function is only available in Z-Wave 0201 libraries.
        /// </summary>
        CmdZWaveSendDataMeta = 0x18,
        /// <summary>
        /// Command to transmit streaming or bulk data in the Z-Wave network.
        /// <br/>NOTE: This function is only available in Z-Wave 0201 libraries.
        /// </summary>
        CmdZWaveSendDataMeta_Bridge = 0xAA,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveSendDataMR = 0x19,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveSendDataMetaMR = 0x1A,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveSetRoutingInfo = 0x1B,
        /// <summary>
        /// Send Test Frame Command.
        /// </summary>
        CmdZWaveSendTestFrame = 0xBE,
        /// <summary>
        /// Command to copy the Home Id and Node Id from the non-volatile memory to the specified RAM addresses.
        /// </summary>
        CmdMemoryGetId = 0x20,
        /// <summary>
        /// Command to read one byte from the non-volatile memory.
        /// </summary>
        CmdMemoryGetByte = 0x21,
        /// <summary>
        /// Command to write one byte to the application area of the non-volatile memory.
        /// </summary>
        CmdMemoryPutByte = 0x22,
        /// <summary>
        /// Command to read a number of bytes from the application area of the EEPROM to a RAM buffer.
        /// </summary>
        CmdMemoryGetBuffer = 0x23,
        /// <summary>
        /// Command to write a number of bytes from the application area of the EEPROM to a RAM buffer.
        /// </summary>
        CmdMemoryPutBuffer = 0x24,
        /// <summary>
        /// Command to write the specified time to the current Real Time Clock.
        /// </summary>
        CmdClockSet = 0x30,
        /// <summary>
        /// Command to copy the current Real Time Clock time to the specified time buffer.
        /// </summary>
        CmdClockGet = 0x31,
        /// <summary>
        /// Command to compare a specified time against the current Real Time Clock time.
        /// </summary>
        CmdClockCompare = 0x32,
        /// <summary>
        /// Command to create a new timer element.
        /// </summary>
        CmdRtcTimerCreate = 0x33,
        /// <summary>
        /// Command to Search in the RTC list and if a used element found, copy the timer element from the RTC timer list to the specified memory buffer.
        /// </summary>
        CmdRtcTimerRead = 0x34,
        /// <summary>
        /// Command to remove the specified timer element from the RTC timer list.
        /// </summary>
        CmdRtcTimerDelete = 0x35,
        /// <summary>
        /// Commad to execute callback function if it specified in <see cref="CmdRtcTimerCreate"/>.
        /// </summary>
        CmdRtcTimerCall = 0x36,
        /// <summary>
        /// Command to get the Node Information frame without command classes from the EEPROM memory.
        /// </summary>
        CmdZWaveGetNodeProtocolInfo = 0x41,
        /// <summary>
        /// Command to remove all Nodes, routing information, assigned homeID/nodeID and RTC timers from the EEPROM memory. This function set the Controller back to the factory default state.
        /// </summary>
        CmdZWaveSetDefault = 0x42,
        /// <summary>
        /// Command to send command completed to sending controller.
        /// </summary>
        CmdZWaveReplicationCommandComplete = 0x44,
        /// <summary>
        /// Command to send the payload and expects the receiver to respond with a command complete message.
        /// </summary>
        CmdZWaveReplicationSendData = 0x45,
        /// <summary>
        /// Command to assign static return routes (up to 4) to a Routing Slave node or Enhanced Slave node.
        /// </summary>
        CmdZWaveAssignReturnRoute = 0x46,
        /// <summary>
        /// Command to delete all static return routes from a Routing Slave node or Enhanced Slave node.
        /// </summary>
        CmdZWaveDeleteReturnRoute = 0x47,
        /// <summary>
        /// Command to get the neighbors from the specified node.
        /// </summary>
        CmdZWaveRequestNodeNeighborUpdate = 0x48,
        /// <summary>
        /// Command to handle "Node Information" frame. See <see cref="CmdZWaveSendNodeInformation"/>.
        /// </summary>
        CmdApplicationControllerUpdate = 0x49,
        /// <summary>
        /// Command to add any nodes to the Z-Wave network.
        /// </summary>
        CmdZWaveAddNodeToNetwork = 0x4a,
        /// <summary>
        /// Command to remove any nodes to the Z-Wave network.
        /// </summary>
        CmdZWaveRemoveNodeFromNetwork = 0x4b,
        /// <summary>
        /// Command to add a controller to the Z-Wave network as a replacement for the old primary controller.
        /// </summary>
        CmdZWaveCreateNewPrimary = 0x4c,
        /// <summary>
        /// Command to add a controller to the Z-Wave network and transfer the role as primary controller to it.
        /// </summary>
        CmdZWaveControllerChange = 0x4d,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveRequestNodeNeighborUpdateMR = 0x4E,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveAssignReturnRouteMR = 0x4F,
        /// <summary>
        /// Command to instruct the controller to allow it to be added or removed from the network.
        /// </summary>
        CmdZWaveSetLearnMode = 0x50,
        /// <summary>
        /// Command to assign the return routes of the SUC node from a Routing Slave node or Enhanced Slave node.
        /// </summary>
        CmdZWaveAssignSucReturnRoute = 0x51,
        /// <summary>
        /// Command to enable/disable assignment of the SUC/SIS functionality in the controller.
        /// </summary>
        CmdZWaveEnableSuc = 0x52,
        /// <summary>
        /// Command to request network topology updates from the SUC/SIS node.
        /// </summary>
        CmdZWaveRequestNetworkUpdate = 0x53,
        /// <summary>
        /// Command to configure a static/bridge controller to be a SUC/SIS node or not.
        /// </summary>
        CmdZWaveSetSucNodeId = 0x54,
        /// <summary>
        /// Command to delete the return routes of the SUC node from a Routing Slave node or Enhanced Slave node.
        /// </summary>
        CmdZWaveDeleteSucReturnRoute = 0x55,
        /// <summary>
        /// Command to get the currently registered SUC node ID.
        /// </summary>
        CmdZWaveGetSucNodeId = 0x56,
        /// <summary>
        /// Command to transmit SUC node Id from a primary controller or static controller to the controller node Id specified.
        /// </summary>
        CmdZWaveSendSucId = 0x57,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveAssignSucReturnRouteMR = 0x58,
        /// <summary>
        /// Command to handle rediscovery needed call.
        /// </summary>
        CmdZWaveRediscoveryNeeded = 0x59,
        /// <summary>
        /// Command to request the node information frame from a controller based node in the network.
        /// </summary>
        CmdZWaveRequestNodeInfo = 0x60,
        /// <summary>
        /// Command to remove a non-responding node from the routing table in the requesting controller.
        /// </summary>
        CmdZWaveRemoveFailedNodeId = 0x61,
        /// <summary>
        /// Command to test if a node ID is stored in the failed node ID list.
        /// </summary>
        CmdZWaveIsFailedNode = 0x62,
        /// <summary>
        /// Command to replace a non-responding node with a new one in the requesting controller.
        /// </summary>
        CmdZWaveReplaceFailedNode = 0x63,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdTimerStart = 0x70,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdTimerRestart = 0x71,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdTimerCancel = 0x72,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdTimerCall = 0x73,
        /// <summary>
        /// Command to read out neighbor information from the protocol.
        /// </summary>
        CmdGetRoutingTableLine = 0x80,
        /// <summary>
        /// Command to get a variable that returns the number of transmits that the protocol has done since last reset of the variable.
        /// </summary>
        CmdGetTXCounter = 0x81,
        /// <summary>
        /// Command to reset a variable that returns the number of transmits 
        /// </summary>
        CmdResetTXCounter = 0x82,
        /// <summary>
        /// Command to restore protocol node information from a backup or the like.
        /// </summary>
        CmdStoreNodeInfo = 0x83,
        /// <summary>
        /// Command to restore HomeID and NodeID information from a backup.
        /// </summary>
        CmdStoreHomeId = 0x84,
        /// <summary>
        /// Command to assure that the response route dont disappear when transmitting a sequence of frames to the same node Id.
        /// </summary>
        CmdLockRouteResponse = 0x90,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveSendDataRouteDemo = 0x91,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdSerialApiTest = 0x95,
        /// <summary>
        /// Command to request application Virtual Slave Node information.
        /// </summary>
        CmdSerialApiSlaveNodeInfo = 0xa0,
        /// <summary>
        /// Command to handle Z-Wave protocol ApplicationSlaveCommandHandler function.
        /// </summary>
        CmdApplicationSlaveCommandHandler = 0xa1,
        /// <summary>
        /// Command to create and transmit a Virtual Slave node "Node Information" frame from source Virtual Slave node.
        /// </summary>
        CmdZWaveSendSlaveNodeInfo = 0xa2,
        /// <summary>
        /// Command to transmit the data buffer to a single Z-Wave Node or all Z-Wave Nodes (NODE_BROADCAST) from the Virtual Slave node.
        /// </summary>
        CmdZWaveSendSlaveData = 0xa3,
        /// <summary>
        /// Command to enables the possibility for enabling or disabling Slave Learn Mode, which when enabled makes it possible for other controllers (primary or inclusion controllers) to add or remove a Virtual Slave Node to the Z-Wave network.
        /// </summary>
        CmdZWaveSetSlaveLearnMode = 0xa4,
        /// <summary>
        /// Command to request a buffer containing available Virtual Slave nodes in the Z-Wave network.
        /// </summary>
        CmdZWaveGetVirtualNodes = 0xa5,
        /// <summary>
        /// Command to check if node is a Virtual Slave node.
        /// </summary>
        CmdZWaveIsVirtualNode = 0xa6,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveReservedSSD = 0xA7,
        /// <summary>
        /// Command to handle Z-Wave protocol ApplicationCommandHandler_Bridge function.
        /// </summary>
        CmdApplicationCommandHandler_Bridge = 0xA8,
        /// <summary>
        /// Reserved Command.
        /// </summary>
        CmdZWaveGetRandom = 0x1c,
        /// <summary>
        /// Command to enable/disable the promiscuous mode.
        /// </summary>
        CmdZWaveSetPromiscuousMode = 0xd0,
    }
}
