using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.Devices
{
    /// <summary>
    /// Representd a properties of <see cref="IDevice"></see> version.
    /// </summary>
    public class VersionInfo
    {
        private string mVersion;
        /// <summary>
        /// Gets or sets the version.
        /// </summary>
        /// <value>The version.</value>
        public string Version
        {
            get { return mVersion; }
            set { mVersion = value; }
        }

        private Libraries mLibrary;
        /// <summary>
        /// Gets or sets the library.
        /// </summary>
        /// <value>The library.</value>
        public Libraries Library
        {
            get { return mLibrary; }
            set { mLibrary = value; }
        }

        private byte mZWaveProtocolVersion = 0;

        /// <summary>
        /// Gets or sets the Z-Wave protocol version.
        /// </summary>
        /// <value>The Z-Wave protocol version.</value>
        public byte ZWaveProtocolVersion
        {
            get { return mZWaveProtocolVersion; }
            set { mZWaveProtocolVersion = value; }
        }
        private byte mZWaveProtocolSubVersion = 0;

        /// <summary>
        /// Gets or sets the Z-Wave protocol sub version.
        /// </summary>
        /// <value>The Z-Wave protocol sub version.</value>
        public byte ZWaveProtocolSubVersion
        {
            get { return mZWaveProtocolSubVersion; }
            set { mZWaveProtocolSubVersion = value; }
        }
        private byte mZWaveApplicationVersion = 0;

        /// <summary>
        /// Gets or sets the Z-Wave application version.
        /// </summary>
        /// <value>The Z-Wave application version.</value>
        public byte ZWaveApplicationVersion
        {
            get { return mZWaveApplicationVersion; }
            set { mZWaveApplicationVersion = value; }
        }
        private byte mZWaveApplicationSubVersion = 0;

        /// <summary>
        /// Gets or sets the Z-Wave application sub version.
        /// </summary>
        /// <value>The Z-Wave application sub version.</value>
        public byte ZWaveApplicationSubVersion
        {
            get { return mZWaveApplicationSubVersion; }
            set { mZWaveApplicationSubVersion = value; }
        }
	
    }
}
