using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Devices
{
    /// <summary>
    /// Represents a single item in a <see cref="ICommandClassesStore"/>.
    /// </summary>
    public class CommandClassesStoreItem
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CommandClassesStoreItem"/> class.
        /// </summary>
        public CommandClassesStoreItem()
        {
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="CommandClassesStoreItem"/> class.
        /// </summary>
        /// <param name="commandClass">The command class.</param>
        /// <param name="nodeMask">The node mask.</param>
        public CommandClassesStoreItem(byte commandClass, byte[] nodeMask)
        {
            CommandClass = commandClass;
            NodeMask = nodeMask;
        }

        private byte mCommandClass;
        /// <summary>
        /// Gets or sets the command class.
        /// </summary>
        /// <value>The command class.</value>
        public byte CommandClass
        {
            get { return mCommandClass; }
            set { mCommandClass = value; }
        }
        private byte[] mNodeMask;
        /// <summary>
        /// Gets or sets the node mask.
        /// </summary>
        /// <value>The node mask.</value>
        public byte[] NodeMask
        {
            get { return mNodeMask; }
            set { mNodeMask = value; }
        }
    }

}
