using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using Zensys.Framework;

namespace Zensys.ZWave.SerialPortApplication.Devices
{
    public class FlashPage : IFlashPage
    {
        private ISessionLayer mSessionLayer;

        public FlashPage(ISessionLayer sessionLayer, IDeviceFlash flash)
        {
            mSessionLayer = sessionLayer;
            Flash = flash;
        }
        private IDeviceFlash mFlash;
        public IDeviceFlash Flash
        {
            get { return mFlash; }
            set { mFlash = value; }
        }
        private byte[] mBuffer;
        public byte[] Buffer
        {
            get { return mBuffer; }
            set { mBuffer = value; }
        }
        private int mAddress;

        public int Address
        {
            get { return mAddress; }
            set { mAddress = value; }
        }

        #region IFlashPage Members
        public bool Write(bool isAsic, bool verify)
        {
            bool result = false;
            int byteNo;
            bool program = false;
            int pageSize;
            if (isAsic)
            {
                pageSize = Constants.BYTES_IN_PAGE;
            }
            else
            {
                pageSize = Constants.FIRMWARE_PAGE_SIZE;
            }
            for (byteNo = 0; byteNo < pageSize; byteNo++)
            {
                if (this.Buffer[byteNo] != Constants.BLANK_VALUE)
                {
                    program = true;
                    break;
                }
            }
            if (program)
            {
                ProgrammerCommandTypes cmd;
                byte[] request = new byte[4 + this.Buffer.Length];
                if (isAsic)
                {
                    cmd = ProgrammerCommandTypes.FUNC_ID_ZW0x0x_WRITE_PAGE;
                    request[0] = (byte)this.Flash.Device.ChipType;
                    request[1] = (byte)this.Address;
                }
                else
                {
                    cmd = ProgrammerCommandTypes.FUNC_ID_M128_BLOCK_WRITE;
                    request[0] = (byte)(this.Address >> 8);
                    request[1] = (byte)(this.Address & 0xFF);
                }
                if (verify)
                {
                    request[2] = 1;
                }
                else
                {
                    request[2] = 0;
                }
                for (int i = 0; i < this.Buffer.Length; i++)
                {
                    request[i + 3] = this.Buffer[i];
                }
                request[this.Buffer.Length + 3] = mSessionLayer.SequenceNumber;
                byte[] response = mSessionLayer.ExecuteRequest((byte)cmd, request);
                if (response.Length > 0)
                {
                    result = (response[0] == (byte)WritePageStatuses.Succeeded);
                }
                if (verify)
                {
                    return result;
                }
            }
            return true;
        }

        public bool Compare(IFlashPage page, bool ignoreCalibrationValue)
        {
            bool result = true;
            if (page.Buffer.Length == this.Buffer.Length)
            {
                for (int i = 0; i < page.Buffer.Length; i++)
                {

                    if (page.Buffer[i] != this.Buffer[i])
                    {
                        if (ignoreCalibrationValue == true)
                        {
                            if (i != Constants.CALIBRATION_VALUE_OTP_POS)
                            {
                                result = false;
                                break;
                            }
                        }
                        else
                        {
                            result = false;
                            break;
                        }
                    }
                }
            }
            else
            {
                result = false;
            }
            return result;
        }

        #endregion
    }
}
