﻿using System;
using System.Collections.Generic;

using System.Text;
using Zensys.Framework;


namespace Zensys.ZWave.Application
{
    public class CommandValue
    {
        private int IndexInData = 0;
        private byte OffsetInData = 0;
        private byte MaskInData = 0;
        private byte BytesCount = 0;

        private Command mCommandDefinition;

        public Command CommandDefinition
        {
            get { return mCommandDefinition; }
            set { mCommandDefinition = value; }
        }
        private List<ParamValue> mParamValues;

        public List<ParamValue> ParamValues
        {
            get { return mParamValues; }
            set { mParamValues = value; }
        }

        public CommandValue()
        {
            ParamValues = new List<ParamValue>();
        }

        internal void ProcessParameters(byte[] data)
        {
            ProcessParameters(data, 0);
        }

        internal void ProcessParameters(byte[] data, byte initialOffsetInData)
        {
            ParamValues.Clear();
            IndexInData = 0;
            byte prevOffsetInData = initialOffsetInData;
            if (CommandDefinition.Param == null)
                return;
            foreach (Param item in CommandDefinition.Param)
            {
                if (string.IsNullOrEmpty(item.OptionalReference) || FindParamValue(item.OptionalReference).ByteValueList[0] > 0)
                {
                    if (item.Bits % 8 == 0)
                    {
                        BytesCount = (byte)(item.Bits / 8);
                        if (item.Size > 0)
                        {
                            BytesCount = (byte)(BytesCount * item.Size);
                        }

                        if (!string.IsNullOrEmpty(item.SizeReference) || item.Type == zwParamType.VARIANT_GROUP)
                        {
                            if (item.SizeReference != "MSG_LENGTH" && item.Type != zwParamType.VARIANT_GROUP)
                            {
                                BytesCount = (byte)(BytesCount * FindParamValue(item.SizeReference).ByteValueList[0]);
                            }
                            else if (IsNextMarkerParameter(item, CommandDefinition.Param))
                            {
                                int pos = Array.IndexOf(data, (byte)0xEF, IndexInData);
                                if (pos > IndexInData)
                                {
                                    BytesCount = (byte)(pos - IndexInData);
                                }
                            }
                            else
                            {
                                int tailLength = GetDataLengthFromParamToEnd(item);
                                BytesCount = (byte)(data.Length - IndexInData - tailLength);
                            }
                        }
                        OffsetInData = 0x00;
                        MaskInData = 0xFF;

                        ParamValue pv = new ParamValue();
                        pv.ParamDefinition = item;
                        for (int i = 0; i < BytesCount; i++)
                        {
                            if (data.Length > IndexInData + i)
                            {
                                pv.ByteValueList.Add(data[IndexInData + i]);
                            }
                        }
                        ParamValues.Add(pv);
                        IndexInData = (byte)(IndexInData + BytesCount);
                        //if (!string.IsNullOrEmpty(item.OptionalReference) || !string.IsNullOrEmpty(item.SizeRef))
                        //{
                        //    VariableLength = (byte)(VariableLength + BytesCount);
                        //}
                    }
                    else
                    {
                        OffsetInData = prevOffsetInData;
                        MaskInData = Tools.GetMaskFromBits(item.Bits, OffsetInData);

                        ParamValue pv = new ParamValue();
                        pv.ParamDefinition = item;
                        if (data.Length > IndexInData)
                        {
                            pv.ByteValueList.Add((byte)((data[IndexInData] & MaskInData) >> OffsetInData));
                        }
                        ParamValues.Add(pv);

                        prevOffsetInData = (byte)(OffsetInData + item.Bits);
                        if (prevOffsetInData == 8)
                        {
                            prevOffsetInData = 0;
                            IndexInData++;
                            //if (!string.IsNullOrEmpty(item.OptionalReference) || !string.IsNullOrEmpty(item.SizeReference))
                            //{
                            //    VariableLength++;
                            //}
                        }
                        else if (prevOffsetInData > 8)
                        {
                            throw new ApplicationException("invalid FrameDefinition File");
                        }
                    }
                }

            }
        }

        private bool IsNextMarkerParameter(Param item, List<Param> list)
        {
            bool next = false;
            foreach (Param var in list)
            {
                if (next)
                {
                    return var.Type == zwParamType.MARKER;
                }
                if (var.Name == item.Name)
                    next = true;
            }
            return false;
        }

        private ParamValue FindParamValue(string name)
        {
            foreach (ParamValue var in ParamValues)
            {
                if (var.ParamDefinition.Name == name)
                    return var;
            }
            return null;
        }

        private int GetDataLengthFromParamToEnd(Param fromParameter)
        {
            int ret = 0;
            bool found = false;
            foreach (Param item in CommandDefinition.Param)
            {
                if (found)
                {
                    if (item.SizeSpecified)
                    {
                        ret += (int)(item.Size * item.Bits) / 8;
                    }
                    else
                    {
                        ret += (int)item.Bits / 8;
                    }
                }
                else
                {
                    if (item.Name == fromParameter.Name)
                    {
                        found = true;
                    }
                }
            }
            return ret;
        }


    }
}
