﻿using System;
using System.Collections.Generic;

using System.Text;

using System.Xml.Serialization;
using Zensys.Framework;

namespace Zensys.ZWave.Application
{
    public partial class Command
    {


        [XmlIgnore]
        public byte KeyId
        {
            get
            {
                return Tools.GetByte(Key);
            }
            set
            {
                Key = Tools.GetHex(value, true);
            }
        }

        private CommandClass parentField;
        [XmlIgnore]
        public CommandClass Parent
        {
            get
            {
                return this.parentField;
            }
            set
            {
                this.parentField = value;
                this.RaisePropertyChanged("Parent");
            }
        }



        public byte[] FillPayload(params byte[] values)
        {
            if (values != null)
            {
                byte[] ret = new byte[values.Length + 2];
                ret[0] = Parent.KeyId;
                ret[1] = KeyId;
                for (int i = 0; i < values.Length; i++)
                {
                    ret[i + 2] = values[i];
                }
                return ret;
            }
            else
            {
                return new byte[] { Parent.KeyId, KeyId };
            }
        }

        public override string ToString()
        {
            return this.Name;
        }
    }
}
